/*
 * file: Panel2D.java
 * 	 -- first program in java2D API
 * @author Chee Yap
 * @date July 24, 2001
 *
 ************************************************************/

// This example is an extension of graphics/MyPanel.java.
//	Read and understand that example first.
//	ACTUALLY, there is absolutely nothing new in this
//	example -- we just recast Graphics to Graphics2D.
//	Externally, there is no visible difference!
//	

import java.awt.Graphics2D;  // strictly redundant...
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// text panel

class TextPanel extends JPanel {

  // override the paintComponent method
  public void paintComponent(Graphics g) {
    Graphics2D g2 = (Graphics2D)g;
    super.paintComponent(g);
    g.drawString("Hello Panel!", 75, 100);

  } //paintComponent
} //class TextPanel

class MyFrame extends JFrame {
  public MyFrame(String s) {
	// Frame Parameters
	setTitle(s);
	setSize(300,200); // default size is 0,0
	setLocation(10,200); // default is 0,0 (top left corner)

	// Window Listeners
	addWindowListener(new WindowAdapter() {
	  public void windowClosing(WindowEvent e) {
		System.exit(0);
	  } //windowClosing
	}); //addWindowLister

	// Add Panels
	Container contentPane = getContentPane();
	contentPane.add(new TextPanel());
  } //constructor MyFrame
} //class MyFrame

public class Panel2D {
  public static void main(String[] args) {
    JFrame f = new MyFrame("My Hello Panel!");
    f.show();
  } //main
} //class Panel2D


