// DrawPanel.java
//   -- extends myPanel.java to illustrates simple drawing primitives

/**
 * We define the class "DrawPanel" which draws (in blue)
 *	-- a Pac Man
 *	-- a pentagon
 *	-- a spiral
 * and their filled versions (in magenta)
 *
 * Primitives used:
 *	-- g.setColor
 *	-- g.drawPolygon
 *	-- g.drawLine
 *	-- g.drawArc
 *	-- f.setBackground
 *	-- g.fillPolygon
 **/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// DrawPanel class (MAIN DEMO)
class DrawPanel extends JPanel {
  // override the paintComponent method
  // THE MAIN DEMO OF THIS EXAMPLE:

  public void paintComponent(Graphics g) {
    // Comment out the following:
    // super.paintComponent(g);
    // Otherwise, it OVERRIDES the frame.setBackground(color) command.

    // graphics Colors:
    g.setColor(Color.blue);

    // Following is INCORRECT: 
    // g.setBackground(Color.yellow);

    // parameters for Pac Man figure:
    int cx  = 50;
    int cy = 100;	// (cx,cy) is center of circle
    int r = 40;	// r is radius of circle
    int angle = 30;	// sector of circle

    int dx = (int)(r * Math.cos(angle * Math.PI / 180));
    int dy = (int)(r * Math.sin(angle * Math.PI / 180));

    // drawing the Pac Man figure
    g.drawLine(cx, cy, cx + dx, cy + dy);	// lower jaw
    g.drawLine(cx, cy, cx + dx, cy - dy);	// upper jaw
    g.drawArc(cx - r, cy - r, 2*r, 2*r, angle, 360-2*angle);
    
    // drawing a filled Pac Man
    cy = 300;
    g.setColor(Color.magenta);
    g.fillArc(cx - r, cy - r, 2*r, 2*r, angle, 360-2*angle);

    // drawing a pentagon
    Polygon pentagon = new Polygon();
    cx = 150; cy = 100;
    int i;
    for (i = 0; i<5; i++)
	pentagon.addPoint(
	  (int)(cx + r * Math.cos(i * 2 * Math.PI / 5)),
	  (int)(cy + r * Math.sin(i * 2 * Math.PI / 5)));
    g.setColor(Color.blue);
    g.drawPolygon(pentagon);

    // drawing a filled pentagon
    cy = 300; 
    Polygon filledPenta = new Polygon();
    for (i = 0; i<5; i++)
	filledPenta.addPoint(
	  (int)(cx + r * Math.cos(i * 2 * Math.PI / 5)),
	  (int)(cy + r * Math.sin(i * 2 * Math.PI / 5)));
    g.setColor(Color.magenta);
    g.fillPolygon(filledPenta);

    // draw a spiral
    cx = 250; cy = 100;
    Polygon spiral = new Polygon();
    for (i = 0; i < 360; i++) {
	double t = i / 360.0;
	spiral.addPoint(
	  (int)(cx + r * t * Math.cos(t * 8 * Math.PI )),
	  (int)(cy + r * t * Math.sin(t * 8 * Math.PI )));
    }
    g.setColor(Color.blue);
    g.drawPolygon(spiral);

    // draw a filled spiral
    cx = 250; cy = 300;
    Polygon filledSpiral = new Polygon();
    for (i = 0; i < 360; i++) {
	double t = i / 360.0;
	filledSpiral.addPoint(
	  (int)(cx + r * t * Math.cos(t * 8 * Math.PI )),
	  (int)(cy + r * t * Math.sin(t * 8 * Math.PI )));
    }
    g.setColor(Color.magenta);
    g.fillPolygon(filledSpiral);

  } //paintComponent
} //class DrawPanel

class DrawFrame extends JFrame {
  public DrawFrame(String s) {
    setTitle(s);
    setSize(300, 400);
    setBackground(Color.yellow); // futile!  This is overridden by panel.
    addWindowListener(new WindowAdapter() {
	public void windowClosing(WindowEvent e) {
	  System.exit(0);
	}
    }); // addWindowListener
    Container contentPane = getContentPane();
    contentPane.add(new DrawPanel());
  } // DrawFrame

  public static void main(String[] args) {
    JFrame f = new DrawFrame("My Drawing Frame");
    f.show();
  } //main

} // DrawFrame


/* NOTES:
	Colors.XXX where XXX=
	black, blue, cyan, darkGray, gray
	green, lightGray, magenta, orange, pink, red, white, yellow
 */
