// ColorButton.java
//   -- the first step in the Java Event model

/**
 *  We will create a class ButtonPanel that extends JPanel,
 *	and simultaneously implements the ActionListener interface.
 *	It has several buttons (here, we only show two, called red and blue).
 *	
 *		class ButtonPanel extends JPanel
 *			implements ActionListener {
 *		  // members:
 *			JButton redButton;
 *			JButton blueButton;
 *		  // constructor:
 *		  public ButtonPanel() {
 *		    redButton = new JButton("Red");
 *		    blueButton = new JButton("Blue");
 *		    add(redButton);  // redButton is added to panel!
 *		    add(blueButton); // blueButton is added to panel!
 *		  } // ButtonPanel()
 *		  ...
 *		} // class
 *
 *  Let "myPanel" be an instance of ButtonPanel:
 *
 *		ButtonPanel myPanel = new ButtonPanel();
 *
 *  Whenever one of these buttons are pressed, 
 *
 **/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// THE MAIN DEMO OF THIS EXAMPLE:
class ButtonPanel extends JPanel
	implements ActionListener {
  // members:
	JButton redButton;
	JButton blueButton;
	JButton greenButton;
	JButton grayButton;
	JButton darkGrayButton;
	JButton cyanButton;
	JButton magentaButton;
	JButton pinkButton;
	JButton orangeButton;
	JButton yellowButton;

  // constructor:
  public ButtonPanel() {

    redButton = new JButton("Red"); // "Red" is label.
    blueButton = new JButton("Blue");
    greenButton = new JButton("Green");
    grayButton = new JButton("Gray");
    darkGrayButton = new JButton("DarkGray");
    cyanButton = new JButton("Cyan");
    magentaButton = new JButton("Magenta");
    pinkButton = new JButton("Pink");
    orangeButton = new JButton("Orange");
    yellowButton = new JButton("Yellow");

    add(redButton);  // redButton is added to panel!
    add(blueButton); // blueButton is added to panel!
    add(greenButton);
    add(grayButton);
    add(darkGrayButton);
    add(cyanButton);
    add(magentaButton);
    add(pinkButton);
    add(orangeButton);
    add(yellowButton);

    redButton.addActionListener(this);
    blueButton.addActionListener(this);
    greenButton.addActionListener(this);
    grayButton.addActionListener(this);
    darkGrayButton.addActionListener(this);
    cyanButton.addActionListener(this);
    magentaButton.addActionListener(this);
    pinkButton.addActionListener(this);
    orangeButton.addActionListener(this);
    yellowButton.addActionListener(this);

  } // constructor ButtonPanel()

  // ActionPerformed method from ActionListener interface
  public void actionPerformed(ActionEvent e){
    Color color = getBackground();  // color will be set
    Object source = e.getSource();
    if (source == redButton) color = Color.red;
    else if (source == blueButton) color = Color.blue;
    else if (source == greenButton) color = Color.green;
    else if (source == grayButton) color = Color.gray;
    else if (source == darkGrayButton) color = Color.darkGray;
    else if (source == cyanButton) color = Color.cyan;
    else if (source == magentaButton) color = Color.magenta;
    else if (source == pinkButton) color = Color.pink;
    else if (source == orangeButton) color = Color.orange;
    else if (source == yellowButton) color = Color.yellow;


    setBackground(color);
    repaint();  // when do we need this??
  } // actionPerformed
} // class ButtonPanel

class ColorButton extends JFrame {
  public ColorButton(String s) {
    setTitle(s);
    setSize(300, 200);
    setBackground(Color.yellow); // futile!  This is overridden by panel.
    addWindowListener(new WindowAdapter() {
	public void windowClosing(WindowEvent e) {
	  System.exit(0);
	}
    }); // addWindowListener
    Container contentPane = getContentPane();
    ButtonPanel bp = new ButtonPanel();
    contentPane.add(bp);
    bp.setBackground(Color.black); 
    bp.repaint();
  } // ColorButton

  public static void main(String[] args) {
    JFrame f = new ColorButton("My Color Button Frame");
    f.show();
  } //main

} // DrawFrame


/* NOTES:
	Colors.XXX where XXX=
	black, blue, cyan, darkGray, gray
	green, lightGray, magenta, orange, pink, red, white, yellow
 */
