// file: MenuAction.java
//  from page 356 of Horstmann and Corneil
//
//  	Illustrating the implementation of "Action" interface
//	  and adding actions to a menu bar.
//	In this demo, we can change the background color of the
//	  panel by choosing menu items.

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// STEP (I): Implementing the Action of setting background color:

class BackgroundColorAction extends AbstractAction {
  //members:
    private Component target;  // where you want the action done!

  //constructor:
  public BackgroundColorAction(
	String name, Icon i, Color c, Component comp) {
    putValue(Action.NAME, name);
    putValue(Action.SMALL_ICON, i);
    putValue("Color", c);
    target = comp;
  } // constructor

  //methods:
  // --actionPerformed is required by the Action interface!
  public void actionPerformed(ActionEvent e) {
    Color c = (Color)getValue("Color");
    target.setBackground(c);
    target.repaint();
  }// actionPerformed method
}// BackgroundColorAction class

// STEP II: Create ActionButton class
// OOPS! THIS CLASS IS NOT USED!

class ActionButton extends JButton {
  // constructor:
  public ActionButton(Action a) {
    setText((String)a.getValue(Action.NAME));
    Icon icon = (Icon)a.getValue(Action.SMALL_ICON);
    if (icon != null) setIcon(icon);
    addActionListener(a);
  }// ActionButton constructor
}// ActionButton class

// STEP III: Associate Actions with Buttons

//  COMPARE THIS CLASS WITH THE ONE IN ButtonFrame.java!
class ButtonPanel extends JPanel {
  // members:
    JButton redButton;
    JButton blueButton;

  // constructor:
  public ButtonPanel() {
    // get the buttons:
    redButton = new JButton("Red"); // "Red" is label.
    blueButton = new JButton("Blue");
    // create the corresponding actions:
    Action redAction = new BackgroundColorAction(
		"Red", new ImageIcon("red-ball.gif"), Color.red, this);
    Action blueAction = new BackgroundColorAction(
		"Blue", new ImageIcon("blue-ball.gif"), Color.blue, this);
    // associate the action to the buttons:
    redButton.addActionListener(redAction);
    blueButton.addActionListener(blueAction);
    // add buttons to panel
    add(redButton);  // redButton is added to panel!
    add(blueButton); // blueButton is added to panel!
  } // constructor ButtonPanel()
} // class ButtonPanel


// STEP IV: PUT ALL THESE IN A FRAME THAT ALSO HAS
//	a menu for setting background colors

class MenuAction extends JFrame {
  // Constructor:
  public MenuAction(String s) {
    setTitle(s);
    setSize(300, 200);
    setBackground(Color.yellow); 
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      } // windowClosing
    }); // WindowAdapter
    Container contentPane = getContentPane();
    JPanel panel = new ButtonPanel();
    contentPane.add(panel);

    // Set Background Color Menu:
    JMenu m = new JMenu("Background Color");
    Action redAction = new BackgroundColorAction(
	"Red", new ImageIcon("red-ball.gif"), Color.red, panel);
    Action blueAction = new BackgroundColorAction(
	"Blue", new ImageIcon("blue-ball.gif"), Color.blue, panel);
    m.add(redAction);
    m.add(blueAction);
    // Menubar
    JMenuBar mbar = new JMenuBar();
    mbar.add(m);
    setJMenuBar(mbar);

  } // MenuAction Constructor
  
  public static void main(String[] args) {
  JFrame f = new MenuAction("My MenuAction Demo");
  f.show();
  } // main
} // MenuAction Class
	
