// DrawFrame1.java
//   -- extends DrawPanel.java to illustrates other drawing primitives
//   -- rectangles, etc

/**
 * We define the class "DrawFrame1" which draws
 *	-- rectangles
 *	-- round rectangles
 * and their filled versions
 *
 * Primitives used:
 *	-- g.drawRect (x, y, dx, dy)
 *	-- g.drawRoundRect (x, y, dx, dy, rx, ry)
 *	-- g.drawOval (x, y, dx, dy)
 **/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// DrawPanel class (MAIN DEMO)
class DrawPanel extends JPanel {
  // override the paintComponent method
  // THE MAIN DEMO OF THIS EXAMPLE:

  public void paintComponent(Graphics g) {

    // rectangle
    g.setColor(Color.cyan);
    g.drawRect(20, 20, 100, 60);
    g.setColor(Color.pink);
    g.drawRoundRect(30, 30, 80, 40, 15, 15);

    // oval
    g.setColor(Color.orange);
    g.drawOval(20, 200, 100, 60);
    g.setColor(Color.lightGray);
    g.fillOval(100, 200, 100, 60);

    // thick rectangles
    int thickness = 4;
    g.setColor(Color.cyan);
    for (int i=0; i <= thickness; i++)
	g.draw3DRect(200 - i, 10 - i,
		     80 + 2*i, 30 + 2*i, true); // true=raised
    g.setColor(Color.orange);
    for (int i=0; i <= thickness; i++)
	g.draw3DRect(200 - i, 80 - i,
		     80 + 2*i, 30 + 2*i, false); // false=pushed

  } //paintComponent
} //class DrawPanel

class DrawFrame1 extends JFrame {
  public DrawFrame1(String s) {
    setTitle(s);
    setSize(300, 400);
    setBackground(Color.black); 
    addWindowListener(new WindowAdapter() {
	public void windowClosing(WindowEvent e) {
	  System.exit(0);
	}
    }); // addWindowListener
    Container contentPane = getContentPane();
    contentPane.add(new DrawPanel());
  } // DrawFrame1

  public static void main(String[] args) {
    JFrame f = new DrawFrame1("My Drawing Frame1");
    f.show();
  } //main

} // DrawFrame


/* NOTES:
	Colors.XXX where XXX=
	black, blue, cyan, darkGray, gray
	green, lightGray, magenta, orange, pink, red, white, yellow
 */
