-- file: gradeCreate.sql
--
-- purpose: This file contains a demo of the \copy command.
--
-- usage: in psql, issue the following command:
--	You must also have another file called "grades"
--
--	=> \i gradeCreate.sql
--
-- It has three steps:
--
-- STEP 1:  Create a table called "Grades" for class grades
-- --------------------------------------------------------------
--	NOTE: if such a table exists, you can first drop it:
--		=> DROP TABLE Grades;
--
-- Table header information:
--     Name    	Hw2	Mid	Hw4	Hw6	HW1	HW3	HW5	FIN
--      	189	170	40	30	50	135	35+5	142

create table Grades
   (name varchar(30),
	hw2 int,
	mid int,
	hw4 int,
	hw6 int,
	hw1 int,
	hw3 int,
	hw5 int,
	fin int);

-- STEP 2: Insert the total score as a special tuple:
-- --------------------------------------------------------------

insert into Grades
	values ('Total Score', 189, 170, 40, 30, 50, 135, 40, 142);

-- STEP 3: Finally, insert the rest of the class scores:
-- --------------------------------------------------------------
-- Use the \copy command (cannot use the SQL COPY command, as that
--    requires superuser permission, etc).
-- DIFFERENCE is that \copy does not need a terminal ";", and
--    the paths are relative to current directory, not absolute paths.

\copy grades from 'grades'

-- Psql Quirk: must use 'grades' and not 'Grades'!  Or it complains
--	that the relation does not exist!
-- CONTRAST WITH the COPY command equivalent:
--     COPY Grades from '/home/yap/prog/postgres/grade/grades';
-- --------------------------------------------------------------
