/************************************************************
 * file: pixmap.cc
 * Visualization Course, Fall 2001
 * Author: Chee Yap
 *
 *      A basic demo of pixel buffer manipulation.
 *      This program reads from two bmp files.  Each bmp image is stored
 *	in an instance of "RGBpixmap" class.  One image is displayed.
 *	Keyboard commands:
 *	   	q = quit
 *		s = switch to the other pixmap for display
 *		f = read bmp file into pixmap again
 *		r = reads into pixmap a 200x200 portion of screen at
 *		    current raster position (set with Left-mouse click,
 *		    see below
 *		w = writes to fixed file name
 *		    
 *	Mouse actions:
 *		Mouse drag  = current image is dragged along
 *		Left-click  = set raster position
 *	  	Right-click = clears the screen. 
 *
 *	NOTE: bmp files are 8-bit or 24-bit color. We only read 24-bit color
 *	You can create 24-bit bmp files using the ubiquitous paint program.
 *
 *      This program is adapted from Hill's book, Figure 10.3, p.536
 ************************************************************/

#include <iostream.h>	// needed for use of cout
#include <math.h>	// needed for math functions exp(x), etc

#ifdef _WINDOZ
	#include <windows.h>
	#include <gl/glut.h>
#else
	#include <GL/glut.h>
#endif


#include "app3.cc"	// grab bag of routines from Appendix 3 of book,
			// but many functions omitted (do not compile)
#include "etc.cc"

/////////////////////////////////////////////////////////////
// Constants
/////////////////////////////////////////////////////////////
  int screenWidth = 640;
  int screenHeight = 480;

  // names of bmp files to read:
  char * fname[3] = {"images/rainbow.bmp", 
	"images/IH-myClub.bmp", "out.bmp"};
  // scaling
  float sx = 1.0; float sy = 1.0;

/////////////////////////////////////////////////////////////
// Initialization
/////////////////////////////////////////////////////////////

  RGBpixmap pic[2]; // create two (empty) global pixmaps
  IntPoint rasterPos(100,100);
  int whichPic = 0; // which pixmap to display

//<<<<<<<<<<<<<<<<<<<<<<<<< myMouse >>>>>>>>>>>>>>>>>>>>>>>>
void myMouse(int button, int state, int mx, int my)
{ // set raster position with a left click	
	if(button == GLUT_LEFT_BUTTON) {	
	  rasterPos.x = mx; rasterPos.y = screenHeight - my;
	  // glRasterPos2i(rasterPos.x, rasterPos.y);
	  glutPostRedisplay();
	}
	else glClear(GL_COLOR_BUFFER_BIT); // clear with right click
}
//<<<<<<<<<<<<<<<<<<<<<<<<< mouseMove >>>>>>>>>>>>>>>>>
void mouseMove(int x, int y)
{// set raster position with mouse motion
	rasterPos.x = x; rasterPos.y = screenHeight - y;
	glRasterPos2i(rasterPos.x, rasterPos.y);
	glutPostRedisplay();
}
//<<<<<<<<<<<<<<<<<<<<<<<<<< myReshape >>>>>>>>>>>>>>>>>>>
void myReshape(int w, int h)
{
screenWidth = w; screenHeight = h;
}
//<<<<<<<<<<<<<<<<<<<<<<< myDisplay >>>>>>>>>>>>>>>>>>>>>>>>>>
void myDisplay(void)
{	
	pic[whichPic].draw(); //draw it at the raster position
} 
//<<<<<<<<<<<<<<<<<<<<<<<< myKeys >>>>>>>>>>>>>>>>>>>>>>
void myKeys(unsigned char key, int x, int y)
{
	switch(key)
	{
	   case 'q': exit(0);
	   case 's': whichPic = 1 - whichPic;
		break; // switch pixmaps
	   case 'r': pic[whichPic].read(rasterPos.x, rasterPos.y,
	   	rasterPos.x+200, rasterPos.y+200);
		break; //grab a piece
	   case 'f':   
  		pic[whichPic].readBMPFile(fname[whichPic]); //make a pixmap
		break; // read file again
	   case 'w':
		pic[whichPic].writeBMPFile(fname[2]); 
		break; // write out the current image
	   case 'i':
		sx *= 1.3; sy *= 1.3;
		glPixelZoom(sx, sy);
		break; // zoom in
	   case 'o':
		sx /= 1.3; sy /= 1.3;
		glPixelZoom(sx, sy);
		break; // zoom in
	}
	glutPostRedisplay();
}
//<<<<<<<<<<<<<<<<<<<<<< main >>>>>>>>>>>>>>>>>>>>>>>>>
int main(int argc, char **argv)
{
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowSize(screenWidth, screenHeight);
	glutInitWindowPosition(30, 30);
	glutCreateWindow("Experiment with images");

	// the next three lines are essential for the
	//	glRasterPos2i(x,y) to work properly!
	glMatrixMode(GL_PROJECTION);
	gluOrtho2D(0.0, (GLdouble)screenWidth,
		0.0, (GLdouble)screenHeight);
	glMatrixMode(GL_MODELVIEW);

	glutKeyboardFunc(myKeys);
	glutMouseFunc(myMouse);		// mouse button down or up
	glutMotionFunc(mouseMove);	// mouse motion with any button down
	glutDisplayFunc(myDisplay);
	glutReshapeFunc(myReshape);

  	glClearColor(0.9f, 0.9f, 0.9f, 0.0); //background color
	glClear(GL_COLOR_BUFFER_BIT);	
  	pic[0].readBMPFile(fname[0]);	//make a pixmap
  	pic[1].readBMPFile(fname[1]); // make another one

	glutMainLoop();
	return 0;
}
