#ifndef _POINTS
#define _POINTS
#include <fstream>
using namespace std;

#include <assert.h>
#include <math.h>
#include <stdlib.h>

//@@@@@@@@@@@@@@@@@@ IntPoint class @@@@@@@@@@@@@@@@
class IntPoint{ // for 2D points with integer coordinates
public: 
	int x,y;
	void set(int dx, int dy);
	void set(IntPoint& p);
	IntPoint(int xx, int yy);
	IntPoint();
};
//@@@@@@@@@@@@@@@@@@ Point2 class @@@@@@@@@@@@@@@@
class Point2{ // for 2D points with real coordinates
public: 
	float x,y;
	void set(float dx, float dy);
	void set(Point2& p);
	Point2(float xx, float yy);
	Point2();
};
//<<<<<<<<<<<<<<<<<<<<<< PolyLine >>>>>>>>>>>>>>>>>>>>>>>>>
class PolyLine{ // a polyline is a num plus an array of points
public:
	int num;
	Point2 pt[80]; //may need larger arrays in some circumstances
	PolyLine();
};
// @@@@@@@@@@@@@@@@@@@@@@@@ IntRect class @@@@@@@@@@@@@@@@@@@@
class IntRect{ // a rectangle with integer border values
public: 
  int left, top, right, bott;
  IntRect();
  IntRect(int l, int t, int r, int b);
  void set(int l, int t, int r, int b);
  void set(IntRect& r);
};
//@@@@@@@@@@@@@@@@@@ Vector2 class @@@@@@@@@@@@@@@@
class Vector2{ 
public: 
	float x,y;
	void set(float dx, float dy);
	void set(Vector2& v);
	void setDiff(Point2& a, Point2& b); //set to difference a - b
	void normalize();		//adjust this vector to unit length
	Vector2(float xx, float yy);
	Vector2(Vector2& v);
	Vector2(); //default constructor
	float dot(Vector2 b); // return this dotted with b
	void perp(); // perp this vector
	float perpDot(Vector2& v); // return perp of this dotted with v
};
//<<<<<<<<<<<<<<<<<<<< Canvas class >>>>>>>>>>>
// a global Canvas object (described in Chapter 3) knows how 
//to draw lines in world coordinates and to perform turtlegraphics
class Canvas {
 private:
	  Point2 CP; 	// current position in world
	  float CD; // current direction in degrees
 public:
	  float windowAspect;
	  Canvas(int width, int height, char* title);
	void setWindow(float l, float r, float b, float t);
	void setViewport(int l, int r, int b, int t);
	float getWindowAspect(void); 
	void lineTo(float x, float y);
	void moveTo(float x, float y);
	void turn(float ang);
	void turnTo(float ang);
	void forward(float dist, int vis);
	void initCT(); // initialize the CT (model view matrix)
	void rotate2D(double angle);
	void translate2D(double dx, double dy);
	void scale2D(double sx, double sy);
	void pushCT(void);
	void popCT(void);
	void ngon(int n, float cx, float cy, float radius);
};
//3D Classes for Graphics

//@@@@@@@@@@@@@@@@@@ Point3 class @@@@@@@@@@@@@@@@
class Point3{ 
public: 
	float x,y,z;
	void set(float dx, float dy, float dz);
	void set(Point3& p);
 Point3(float xx,     float yy, float zz);
	Point3();
	void build4tuple(float v[]);
};
//@@@@@@@@@@@@@@@@@@ Vector3 class @@@@@@@@@@@@@@@@
class Vector3{ 
public: 
	float x,y,z;
	void set(float dx, float dy, float dz);
	void set(Vector3& v);
	void flip(); // reverse this vector
	void setDiff(Point3& a, Point3& b);  //set to difference a - b
	void normalize(); //adjust this vector to unit length
	Vector3(float xx, float yy, float zz);
	Vector3(Vector3& v);
	Vector3(); //default constructor
	Vector3 cross(Vector3 b); //return this cross b
	float dot(Vector3 b); // return this dotted with b
};

// @@@@@@@@@@@@@@@@@@@@@ Color3 class @@@@@@@@@@@@@@@@
class Color3 { // holds an red,green,blue 3-tuple
public:
	float red, green, blue;
	Color3();
	Color3(float r, float g, float b);
	Color3(Color3& c);
	void set(float r, float g, float b);
	void set(Color3& c);
	void add(float r, float g, float b);
	void add(Color3& src, Color3& refl);
	void add(Color3& colr);
	void build4tuple(float v[]);
};
//@@@@@@@@@@@@@@@@@@@@ light class @@@@@@@@@@@@@@@@@@@
class Light{ // for a linked list of light sources color and position
public:
	Point3 pos;
	Color3 color;
	Light* next;
	void setPosition(Point3 p);
	void setColor(Color3 c);
	Light();
};

#endif
