#include "points.h"
#include <string>
#include <iostream>
using namespace std;

#include <assert.h>
#include <math.h>
#include <stdlib.h>
#ifdef _WINDOZ
	#include <windows.h> //change if using xWindows
	#include <gl/glut.h>
#else
	#include <GL/glut.h>
#endif

//@@@@@@@@@@@@@@@@@@ IntPoint class @@@@@@@@@@@@@@@@
void IntPoint::set(int dx, int dy)
{x = dx; y = dy;}

void IntPoint::set(IntPoint& p)
{ x = p.x; y = p.y;} 

IntPoint::IntPoint(int xx, int yy)
{x = xx; y = yy;}

IntPoint::IntPoint()
{ x = y = 0;}

//@@@@@@@@@@@@@@@@@@ Point2 class @@@@@@@@@@@@@@@@
void Point2::set(float dx, float dy)
{x = dx; y = dy;}

void Point2::set(Point2& p)
{ x = p.x; y = p.y;} 

Point2::Point2(float xx, float yy)
{x = xx; y = yy;}

Point2::Point2()
{x = y = 0;}

//<<<<<<<<<<<<<<<<<<<<<< PolyLine >>>>>>>>>>>>>>>>>>>>>>>>>
PolyLine::PolyLine()
{num = 0;}

// @@@@@@@@@@@@@@@@@@@@@@@@ IntRect class @@@@@@@@@@@@@@@@@@@@
IntRect::IntRect()
{left = top = right = bott = 0;}

IntRect::IntRect(int l, int t, int r, int b)
{left = l; top = t; right = r; bott = b;}

void IntRect::set(int l, int t, int r, int b)
{left = l; top = t; right = r; bott = b;}

void IntRect::set(IntRect& r)
{left = r.left; top = r.top; right = r.right; bott = r.bott;}

//@@@@@@@@@@@@@@@@@@ Vector2 class @@@@@@@@@@@@@@@@
void Vector2::set(float dx, float dy)
{ x = dx; y = dy; }

void Vector2::set(Vector2& v)
{ x = v.x; y = v.y;}

void Vector2::setDiff(Point2& a, Point2& b)  //set to difference a - b
{x = a.x - b.x; y = a.y - b.y;}

void Vector2::normalize()   //adjust this vector to unit length
{
	double sizeSq = x * x + y * y;
	if(sizeSq < 0.0000001)
	{
		cerr << "\nnormalize() sees vector (0,0)!";
		return; // does nothing to zero vectors;
	}
	float scaleFactor = 1.0/(float)sqrt(sizeSq);
	x *= scaleFactor; y *= scaleFactor;
}

Vector2::Vector2(float xx, float yy)
{x = xx; y = yy; }

Vector2::Vector2(Vector2& v)
{x = v.x; y = v.y; }

Vector2::Vector2()
{x = y = 0;} //default constructor

float Vector2::dot(Vector2 b) // return this dotted with b
{return x * b.x + y * b.y;}

void Vector2::perp() // perp this vector
{float tmp = x; x = -y; y = tmp;}

float Vector2::perpDot(Vector2& v) // return perp of this dotted with v
{return x *v.x - y * v.y;}

//<<<<<<<<<<<<<<<<<<<< Canvas class >>>>>>>>>>>
// a global Canvas object (described in Chapter 3) knows how 
//to draw lines in world coordinates and to perform turtlegraphics
Canvas::Canvas(int width, int height, char* title)
{
	char* list; //dummy list for glutInit
	int numArgs = 1;//dummy value for glutInit
	glutInit(&numArgs, &list);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowSize(width, height);
	glutInitWindowPosition(100, 100);
	glutCreateWindow(title);
	CP.x = CP.y = 0.0;
	windowAspect = 1.0;
}

void Canvas::setWindow(float l, float r, float b, float t)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D((GLdouble)l, (GLdouble)r, (GLdouble)b, (GLdouble)t);
	if(t == b) return;
	windowAspect = (r - l)/(t - b);
}

void Canvas::setViewport(int l, int r, int b, int t)
{glViewport((GLint)l, (GLint)b, (GLint)(r-l), (GLint)(t-b));}	

float Canvas::getWindowAspect(void)
{ return windowAspect;}

void Canvas::lineTo(float x, float y)
{
	glBegin(GL_LINES);
	glVertex2f((GLfloat)CP.x, (GLfloat)CP.y);
	CP.x = x; CP.y = y;
	glVertex2f((GLfloat)CP.x, (GLfloat)CP.y);
	glEnd(); 	glFlush();
}

void Canvas::moveTo(float x, float y)
{CP.x = x; CP.y = y;}

void Canvas::turn(float ang)
{CD += ang;}

void Canvas::turnTo(float ang)
{CD = ang;}

void Canvas::forward(float dist, int vis)	
{
	#define RadPerDeg 0.017453393 //radians per degree
	float x = CP.x + dist * cos(RadPerDeg * CD);
	float y = CP.y + dist * sin(RadPerDeg * CD);
	if(vis) lineTo(x, y);
	else moveTo(x, y);
	CP.x = x; CP.y = y;
}

void Canvas::initCT() // initialize the CT (model view matrix)
{
	glMatrixMode(GL_MODELVIEW); glLoadIdentity();
}

void Canvas::rotate2D(double angle)
{
	glMatrixMode(GL_MODELVIEW); glRotated(angle, 0.0, 0.0, 1.0);	
}

void Canvas::translate2D(double dx, double dy)
{
	glMatrixMode(GL_MODELVIEW); glTranslated(dx, dy, 0.0);
}

void Canvas::scale2D(double sx, double sy)
{
	glMatrixMode(GL_MODELVIEW); glScaled(sx, sy, 1.0);
}

void Canvas::pushCT(void)
{
	glMatrixMode(GL_MODELVIEW); glPushMatrix();
}

void Canvas::popCT(void)
{
	glMatrixMode(GL_MODELVIEW); glPopMatrix();
}

void Canvas::ngon(int n, float cx, float cy, float radius) {}

//@@@@@@@@@@@@@@@@@@ Point3 class @@@@@@@@@@@@@@@@
void Point3::set(float dx, float dy, float dz)
{x = dx; y = dy; z = dz;}

void Point3::set(Point3& p)
{x = p.x; y = p.y; z = p.z;}

Point3::Point3(float xx, float yy, float zz)
{x = xx; y = yy; z = zz;}

Point3::Point3()
{x = y = z = 0;}

void Point3::build4tuple(float v[])
{// load 4-tuple with this color: v[3] = 1 for homogeneous
	v[0] = x; v[1] = y; v[2] = z; v[3] = 1.0f;
}	

//@@@@@@@@@@@@@@@@@@ Vector3 class @@@@@@@@@@@@@@@@
void Vector3::set(float dx, float dy, float dz)
{ x = dx; y = dy; z = dz;}

void Vector3::set(Vector3& v)
{ x = v.x; y = v.y; z = v.z;}

void Vector3::flip()
{x = -x; y = -y; z = -z;} // reverse this vector

void Vector3::setDiff(Point3& a, Point3& b)//set to difference a - b
{ x = a.x - b.x; y = a.y - b.y; z = a.z - b.z;}

void Vector3::normalize()//adjust this vector to unit length
{		
	double sizeSq = x * x + y * y + z * z;
	if(sizeSq < 0.0000001)
	{
		cerr << "\nnormalize() sees vector (0,0,0)!";
		return; // does nothing to zero vectors;
	}
	float scaleFactor = 1.0/(float)sqrt(sizeSq);
	x *= scaleFactor; y *= scaleFactor; z *= scaleFactor;
}

Vector3::Vector3(float xx, float yy, float zz)
{x = xx; y = yy; z = zz;}

Vector3::Vector3(Vector3& v)
{x = v.x; y = v.y; z = v.z;}

Vector3::Vector3()
{x = y = z = 0;} //default constructor

Vector3 Vector3::cross(Vector3 b) //return this cross b
{
   Vector3 c(y*b.z - z*b.y, z*b.x - x*b.z, x*b.y - y*b.x);
   return c;
}

float Vector3::dot(Vector3 b) // return this dotted with b
{return x * b.x + y * b.y + z * b.z;}

// @@@@@@@@@@@@@@@@@@@@@ Color3 class @@@@@@@@@@@@@@@@
Color3::Color3()
{red = green = blue = 0;}

Color3::Color3(float r, float g, float b)
{red = r; green = g; blue = b;}

Color3::Color3(Color3& c)
{red = c.red; green = c.green; blue = c.blue;}

void Color3::set(float r, float g, float b)
{red = r; green = g; blue = b;}

void Color3::set(Color3& c) 
{red = c.red; green = c.green; blue = c.blue;}

void Color3::add(float r, float g, float b)
{red += r; green += g; blue += b;}

void Color3::add(Color3& src, Color3& refl)
   { // add the product of source color and reflection coefficient
	red   += src.red   * refl.red;
	green += src.green * refl.green; 
	blue  += src.blue  * refl.blue;
}

void Color3::add(Color3& colr)
{ // add colr to this color
	red += colr.red ; green += colr.green; blue += colr.blue;
}

void Color3::build4tuple(float v[])
{// load 4-tuple with this color: v[3] = 1 for homogeneous
	v[0] = red; v[1] = green; v[2] = blue; v[3] = 1.0f;
}

//@@@@@@@@@@@@@@@@@@@@ light class @@@@@@@@@@@@@@@@@@@
void Light::setPosition(Point3 p)
{pos.set(p);}

void Light::setColor(Color3 c)
{color.set(c);}

Light::Light()
{next = NULL;}

