// Noise class for generating pseudorandom noise fields
//based on noise lattice a la Peachey/Perlin
#ifndef _AUX_H
#define _AUX_H
#include <assert.h>

class Noise{
public:
	Noise();  //construct a noise object

	float noise(float scale, Point3& p);
	float turbulence(float s, Point3& p);
	float marble(float strength,Point3& p);
private:
	float* noiseTable; // array of noise values
	unsigned char * index; //Pseudo random indices
	float mySpline(float x); // used for marble
	float latticeNoise(int i, int j, int k);
}; // end of Noise class

// uses several of the basic classes developed above
// uses classes: DefUnit, DefUnitStack 
// uses Affine4 and associated classes
// uses Shapes class as well

//@@@@@@@@@@@@@  Scene class @@@@@@@@@@@@@@@@@@@@

// @@@@@@@@@@@@@@@@@@@@@ Affine4 class @@@@@@@@@@@@@@@@
class Affine4 {// manages homogeneous affine transformations
// including inverse transformations
// and a stack to put them on
// used by Scene class to read SDL files
public:
	float m[16]; // hold a 4 by 4 matrix
	Affine4();
	void setIdentityMatrix(); // make identity transform
	void set(Affine4 a); // set this matrix to a
	//<<<<<<<<<<<< postMult >>>>>>>>>>>
	void postMult(Affine4 n); // postmultiplies this with n
}; // end of Affine4 class

//@@@@@@@@@@ AffineNode class @@@@@@@@@@@
class AffineNode{
// used by Scene class to read SDL files
public:
	Affine4 * affn;
	Affine4 * invAffn;
	AffineNode * next;
	AffineNode();
	~AffineNode(); //destructor
};
//@@@@@@@@@@@@@@@@ AffineStack class @@@@@@@@@@@@
class AffineStack{
// used by Scene class to read SDL files
public:
	AffineNode * tos;
	AffineStack(); //default constructor;puts identity on top
	void dup();
	void setIdentity(); // make top item the identity matrix
	void popAndDrop();
	void releaseAffines(); // pop and drop all remaining items 
	void rotate(float angle, Vector3 u);
	void scale(float sx, float sy, float sz);// post-multiply top item
						 // by scaling
	void translate(Vector3 d);
}; // end of AffineStack class



//@@@@@@@@@@@@@@@@@@@ PointCluster class @@@@@@@@@@@@@@@@@@
class PointCluster{
public: // holds array of points for the bounding hull of a shape
	int num;
	Point3* pt;
	PointCluster();
	PointCluster(int n);// make a cluster of n points
};
//@@@@@@@@@@@@@@@@@@@@@@@@@@ SphereInfo @@@@@@@@@@@@@@@@@@@@@
class SphereInfo{// holds the center and radius of a sphere
public:
	Point3 center;
	float radSq;
	void set(float x, float y, float z, float rsq);
};
//@@@@@@@@@@@@@@@@@@@@@@@@ Cuboid @@@@@@@@@@@@@@@@@@@@@@@@
class Cuboid{ // holds six border values of a cuboid
public:
	float left, top, right, bott, front, back;
	void set(float l, float t, float r, float b, float f, float bk);
	void set(Cuboid& c);
	void print();
};

//@@@@@@@@@@@@@@@@@@@@ Ray @@@@@@@@@@@@@@@@@@@@@@@@@
#endif
