// RGBpixmap.h: a class to support working with RGB pixmaps.
#ifndef _RGBPIXMAP
#define _RGBPIXMAP
#include "points.h"
#include <fstream>
#include <string>
#include <assert.h>

#include <stdlib.h>

typedef unsigned char uchar;

class mRGB{   // the name RGB is already used by Windows
public: uchar r,g,b;
	mRGB();
	mRGB(mRGB&);
	mRGB(uchar, uchar, uchar);
	void set(uchar, uchar, uchar);
};
//$$$$$$$$$$$$$$$$$ RGBPixmap class $$$$$$$$$$$$$$$
class RGBpixmap{
private: 
public:
	int nRows, nCols; // dimensions of the pixmap
	mRGB* pixel; // array of pixels

//METHODS:
	RGBpixmap();
	RGBpixmap(int rows, int cols); //constructor
//	~RGBpixmap();
	int readBMPFile(string fname); // read BMP file into this pixmap
	int writeBMPFile(char * fname); // write pixmap into BMP file
	void freeIt(); // give back memory for this pixmap
	//<<<<<<<<<<<<<<<<<< copy >>>>>>>>>>>>>>>>>>>
	void copy(IntPoint from, IntPoint to, int x, int y,
		 int width, int height);
	//<<<<<<<<<<<<<<<<<<< draw >>>>>>>>>>>>>>>>>
	void draw();
	void draw(int x, int y);
	//<<<<<<<<<<<<<<<<< read >>>>>>>>>>>>>>>>
	int read(int x, int y, int wid, int ht);
	//<<<<<<<<<<<<<<<<< read from IntRect >>>>>>>>>>>>>>>>
	int read(IntRect r);
	//<<<<<<<<<<<<<< setPixel >>>>>>>>>>>>>
	void setPixel(int x, int y, mRGB color);
	//<<<<<<<<<<<<<<<< getPixel >>>>>>>>>>>
	mRGB getPixel(int x, int y);
}; //end of class RGBpixmap
#endif
