struct Point2{
	double x;
	double y;
};

struct Line {
	double startx;
	double starty;
	double endx;
	double endy;	
};

class State{
  private:	
	char name[2]; 							// the acronym of the state, e.g. NY for New York
	
	// the bounding box of the state
	double left_bound; 
	double right_bound;
	double bottom_bound;
	double top_bound;
	
	int total_lines;						// the number of line segments in the state

  public:
  	Line* lines;							// pointer of line segments
  	
  	State();
  	~State();
  	
	void setName(const char* state_name);	
	char* getName();
	int get_total_lines();
	
	void setLeftBound(double bound);
	void setRightBound(double bound);
	void setBottomBound(double bound);
	void setTopBound(double bound);
	
	double getLeftBound();
	double getRightBound();
	double getBottomBound();
	double getTopBound();
	
    	void readStateMap(char* fileName);
    
    
}; // class State