#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "state.h"

const int MAX_LINES_PER_STATE = 50000;   	// maximum number of lines of any one state, max -> TX 48403

	/********************************
	Constructor
	*********************************/		
	State::State(){
		lines = (Line*)malloc(MAX_LINES_PER_STATE*sizeof(Line)); 
		//printf("Constructor called\n");	
	}
	
	/********************************
	Destructor
	*********************************/		
	State::~State(){
		free(lines);
		//printf("Destructor called\n");	
	}
	
	/********************************
	set name for state 
	*********************************/	
	void State::setName(const char* state_name){
		strcpy(name, state_name);
	}
	
	/*******************************
	get the name of the state
	*********************************/	
	char* State::getName(){
		return name;	
	}

	/*********************************
  	read map data from file
	**********************************/  
    void State::readStateMap(char* fileName){
    	FILE* f;
    	int i;
    	char s[1000];
    	char t[100];
    	char* p;
    	int len;
    	int x, y;
    	
    	f = fopen(fileName, "r");
    	
    	int extend_left, extend_right, extend_bottom, extend_top;
    	fscanf(f, "%i", &extend_left);
    	fscanf(f, "%i", &extend_right);
    	fscanf(f, "%i", &extend_bottom);
    	fscanf(f, "%i", &extend_top);	
      
      	left_bound=((double)extend_left)/1000000.0;
      	right_bound=((double)extend_right)/1000000.0;
      	bottom_bound=((double)extend_bottom)/1000000.0;
      	top_bound=((double)extend_top)/1000000.0;	

    	i = 0;
    	while ( fgets(s, 1000, f) != NULL ){
    		len = strlen(s);
    		p = s;
    		while ( p < s + len - 1 ){
    			strncpy(t, p, 19);
    			sscanf(t, "%i%i", &x, &y);				
    			if ( p == s ) { // the 1st point of one line 
    				lines[i].startx = x;
    				lines[i].starty = y;
    			} else { // other points of one line
    				lines[i].endx = x;
    				lines[i].endy = y;
    				lines[i].startx= lines[i].startx/1000000.0;
    				lines[i].starty= lines[i].starty/1000000.0;
    				lines[i].endx= lines[i].endx/1000000.0;
    				lines[i].endy= lines[i].endy/1000000.0;

    				i++;
    				if ( p + 19 != s + len - 1 ) { // not the last point of one line
    					lines[i].startx = x;
    					lines[i].starty = y;
    				}
    			}
    			p += 19;
    		} // while p < s + len - 1
	} // while fgets(s, 1000, f) != null
    	total_lines = i;
    	//printf("total_lines=%d\n", total_lines);
    	fclose(f);	
    } // readStateMap()
    
    int State::get_total_lines(){
    	return total_lines;
    }
    
	void State::setLeftBound(double bound){
		left_bound = bound;	
	}
	
	void State::setRightBound(double bound){
		right_bound = bound;
	}
	
	void State::setBottomBound(double bound){
		bottom_bound = bound;
	}
	
	void State::setTopBound(double bound){
		top_bound = bound;
	}
	
	double State::getLeftBound(){
		return left_bound;
	}
	
	double State::getRightBound(){
		return right_bound;	
	}
	
	double State::getBottomBound(){
		return bottom_bound;	
	}
	
	double State::getTopBound(){
		return top_bound;	
	}
/*
int main(){
	const int numState = 54;					// number of states		
	const char* stateName[numState] = {
		"AK", "AL", "AR", "AZ", "CA", "CO", "CT", "DC", "DE",
		"FL", "GA", "GU", "HI", "IA", "ID", "IL", "IN", "KS",
		"KY", "LA", "MA", "MD", "ME", "MI", "MN", "MO", "MS",
		"MT", "NC", "ND", "NE", "NH", "NJ", "NM", "NV", "NY",
		"OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN",
		"TX", "UT", "VA", "VI", "VT", "WA", "WI", "WV", "WY"	
	};	
	State state[numState];
	
	const char* map_dir = "data";				// the subdirectory that saves the map data
	const char* file_suffix = "Lines.txt";		// the suffix of map data file	
	char file_name[128];
	
	for ( int i = 0; i < numState; i++){
		state[i].setName(stateName[i]);
		strcpy(file_name, map_dir);
		strcat(file_name, "/");
		strcat(file_name, state[i].getName());
		strcat(file_name, file_suffix);
		//printf("file_name = %s\n", file_name);
		state[i].readStateMap(file_name);
		printf("%s: %i\n", state[i].getName(), state[i].get_total_lines());
	}	
	return 0;	
}
*/