#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include "state.h"

const int MAX_POINTS = 5000000;
const int numState = 53;
const char* stateName[numState] = {
	/*"AK",*/ "AL", "AR", "AZ", "CA", "CO", "CT", "DC", "DE",
	"FL", "GA", "GU", "HI", "IA", "ID", "IL", "IN", "KS",
	"KY", "LA", "MA", "MD", "ME", "MI", "MN", "MO", "MS",
	"MT", "NC", "ND", "NE", "NH", "NJ", "NM", "NV", "NY",
	"OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN",
	"TX", "UT", "VA", "VI", "VT", "WA", "WI", "WV", "WY"	
};
			 
//const int screenWidth=640;
//const int screenHeight=480;

Line* resultTLine; // the result of query

int total_tline_num = 0;

State state[numState];
const char* map_dir = "data";					// the subdirectory that saves the map data
const char* file_suffix = "Lines.txt";				// the suffix of map data file
char file_name[128];						// map file name
double left_bound,right_bound,bottom_bound,top_bound;   // the boundary of the whole USA map

/*void myMouse(int BUTTON, int state, int x, int y) {
	if (BUTTON == GLUT_RIGHT_BUTTON && state == GLUT_DOWN) {
		posX = x;
		posY = y;
	}
	else if (BUTTON == GLUT_RIGHT_BUTTON && state == GLUT_UP) {
		posX = x;
		posY = y;
	}
		

} */


void getTLine(double x_left, double x_right, double y_top, double y_bottom) {
	
	int stateIndex[numState];
	int file_num = 0;

	total_tline_num = 0;
	
	for ( int j = 0; j < numState; j++) {
		
		double state_left = state[j].getLeftBound();
		double state_right = state[j].getRightBound();
		double state_top = state[j].getTopBound();
		double state_bottom = state[j].getBottomBound();
		
		//printf("state_left=%d\n", state_left);
		//printf("state_right=%d\n", state_right);
		//printf("state_bottom=%d\n", state_bottom);
		//printf("state_top=%d\n", state_top);
		
		int count=0;
		
		if (x_left>=state_left && x_left<=state_right && y_bottom<=state_bottom && y_top>=state_bottom) {
			count++;
		}
		if (x_left>=state_left && x_left<=state_right && y_bottom<=state_top && y_top>=state_top) {
			count++;
		}
		if (x_left>=state_left && x_left<=state_right && y_top>=state_top && y_bottom<=state_bottom) {
			count++;
		}
		if (x_right>=state_left && x_right<=state_right && y_bottom>=state_bottom && y_top<=state_top) {
			count++;
		}
		if (x_right>=state_left && x_right<=state_right && y_bottom<=state_bottom && y_top>=state_bottom) {
			count++;
		}
		if (x_right>=state_left && x_right<=state_right && y_bottom<=state_top && y_top>=state_top) {
			count++;
		}
		if (x_right>=state_left && x_right<=state_right && y_top>=state_top && y_bottom<=state_bottom) {
			count++;
		}
		if (x_right>=state_left && x_right<=state_right && y_top<=state_top && y_bottom>=state_bottom) {
			count++;
		}
		if (x_left<=state_left && x_right>=state_right && y_bottom<=state_bottom && y_top>=state_bottom) {
			count++;
		}
		if (x_left<=state_left && x_right>=state_right && y_bottom<=state_top && y_top>=state_top) {
			count++;
		}
		if (x_left<=state_left && x_right>=state_right && y_bottom>=state_bottom && y_top<=state_top) {
			count++;
		}
		if (x_left<=state_left && x_right>=state_right && y_bottom<=state_bottom && y_top>=state_top) {
			count++;
		}
		if (x_left>=state_left && x_right<=state_right && y_bottom<=state_bottom && y_top>=state_bottom) {
			count++;
		}
		if (x_left>=state_left && x_right<=state_right && y_bottom<=state_top && y_top>=state_top) {
			count++;
		}
		if (x_left>=state_left && x_right<=state_right && y_bottom>=state_bottom && y_top<=state_top) {
			count++;
		}
		if (x_left>=state_left && x_right<=state_right && y_bottom<=state_bottom && y_top>=state_top) {
			count++;
		}
		
		if (count>=1) {
			stateIndex[file_num] = j;
			file_num++;
		}
	} // end for state

// determine if the lines are in the boundary

	//printf("file_num=%d\n", file_num);	

	for (int i = 0; i < file_num; i++ ) { // i is for state index
		int k = stateIndex[i];
		for (int j = 0; j < state[k].get_total_lines(); j++){ // j is for line index
			
			int count = 0;			
			
			double point_top;
			double point_bottom;
			double point_left;
			double point_right;
			
			if ( state[k].lines[j].startx < state[k].lines[j].endx ){
				point_left = state[k].lines[j].startx;
				point_right = state[k].lines[j].endx;	
			} else {
				point_left = state[k].lines[j].endx;
				point_right = state[k].lines[j].startx;					
			}
			if ( state[k].lines[j].starty < state[k].lines[j].endy ){
				point_top = state[k].lines[j].endy;
				point_bottom = state[k].lines[j].starty;	
			} else {
				point_top = state[k].lines[j].starty;
				point_bottom = state[k].lines[j].endy;					
			}
			
			if (point_top>=y_top && point_bottom<=y_top) {
				if (point_right<=x_right && point_left>=point_left) {
					count++;
				}
				else if (point_left<=x_left && point_right>=x_left) {
					count++;
				}
				else if (point_right>=x_right && point_left<=x_right) {
					count++;
				}
				else if (point_right>=x_left && point_left<=x_left) {
					count++;
				}
			}
			
			else if (point_top<=y_top && point_bottom>=y_bottom) {
				if (point_left<=x_left && point_right>=x_left) {
					count++;
				}
				else if (point_right>=x_right && point_left<=x_right) {
					count++;
				}
				else if (point_right<=x_right && point_left>=x_left) {
					count++;
				}
				else if (point_right>=x_right && point_left<=x_left) {
					count++;
				}
			}
			
			else if (point_top>=y_bottom && point_bottom<=y_bottom) {
				if (point_right<=x_right && point_left>=point_left) {
					count++;
				}
				else if (point_left<=x_left && point_right>=x_left) {
					count++;
				}
				else if (point_right>=x_right && point_left<=x_right) {
					count++;
				}
				else if (point_right>=x_left && point_left<=x_left) {
					count++;
				}
			}
			//printf("count=%d\n", count);
			if (count>=1) {
				resultTLine[total_tline_num].startx = state[k].lines[j].startx;
				resultTLine[total_tline_num].endx = state[k].lines[j].endx;
				resultTLine[total_tline_num].starty = state[k].lines[j].starty;
				resultTLine[total_tline_num].endy = state[k].lines[j].endy;
				total_tline_num++;
			} // if 
		} // end for j
	} // end for i
} // end of getTLine()


/***************************************************************/
/* Compute boundary of the whole USA map			           */
/***************************************************************/
void getUSBoundary(){
	FILE* f;

	for ( int i = 0; i < numState; i++){
		state[i].setName(stateName[i]);
		strcpy(file_name, map_dir);
		strcat(file_name, "/");
		strcat(file_name, state[i].getName());
		strcat(file_name, file_suffix);	
    	
    		f = fopen(file_name, "r");
    	    	
    		int extend_left, extend_right, extend_bottom, extend_top;
    		fscanf(f, "%i", &extend_left);
    		fscanf(f, "%i", &extend_right);
    		fscanf(f, "%i", &extend_bottom);
    		fscanf(f, "%i", &extend_top);				
    	
      		state[i].setLeftBound( ((double)extend_left)/1000000.0 );
      		state[i].setRightBound( ((double)extend_right)/1000000.0 );
      		state[i].setBottomBound( ((double)extend_bottom)/1000000.0 );
      		state[i].setTopBound( ((double)extend_top)/1000000.0 );	    	
/*      		
      		printf("%s\n", state[i].getName());
      		printf("%f\n", state[i].getLeftBound());
      		printf("%f\n", state[i].getRightBound());
      		printf("%f\n", state[i].getBottomBound());
      		printf("%f\n", state[i].getTopBound());
*/      		
    	} // for
    
    left_bound = state[0].getLeftBound();;
    right_bound = state[0].getRightBound();
    bottom_bound = state[0].getBottomBound();
    top_bound = state[0].getTopBound();
    
    for ( int i = 1; i < numState; i++) {
    	double bound; 
    	
    	bound = state[i].getLeftBound();
    	if ( bound < left_bound )
    		left_bound = bound;	
    	bound = state[i].getRightBound();	
    	if ( bound > right_bound )
    		right_bound = bound;	
    	bound = state[i].getBottomBound();	
    	if ( bound < bottom_bound )
    		bottom_bound = bound;	
    	bound = state[i].getTopBound();	
    	if ( bound > top_bound )
    		top_bound = bound;
    }
    printf("left_bound = %f\n", left_bound);
    printf("right_bound = %f\n", right_bound);
    printf("bottom_bound = %f\n", bottom_bound);
    printf("top_bound = %f\n", top_bound);
/*    
    double A,B,C,D;
    A = (ScreenWidth-ScreenHeight/3) / (right_bound - left_bound);
    B = ScreenHeight / (top_bound - bottom_bound);
    C = -A * left_bound;
    D = -B * bottom_bound;    
    
    for ( int j = 0; j < numState; j++) {
 	int total = state[j].get_total_lines();
  	for ( int i=0; i < total; i++){
  		state[j].lines[i].startx = A * state[j].lines[i].startx + C;
  		state[j].lines[i].starty = B * state[j].lines[i].starty + D;
  		state[j].lines[i].endx   = A * state[j].lines[i].endx   + C;
  		state[j].lines[i].endy   = B * state[j].lines[i].endy   + D; 
  	}
    }
*/
} // getUSBoundary()		
void main() {
	getUSBoundary();
  	for ( int j = 0; j < numState; j++) {
		state[j].setName(stateName[j]);
		strcpy(file_name, map_dir);
		strcat(file_name, "/");
		strcat(file_name, state[j].getName());
		strcat(file_name, file_suffix);  		
  		state[j].readStateMap(file_name);
  	}		
  	resultTLine = (Line*)malloc(MAX_POINTS*sizeof(Line)); 
 	getTLine(left_bound, right_bound, top_bound, bottom_bound);
    printf("%d\n", total_tline_num);
    free(resultTLine);    
}
