#include <string>
#include <iostream>
#include <fstream>
#include <sstream>

#include "hw3.h"

ostream& operator<<(ostream& os, Point2& p) {
    os.setf(ios::showpos);
    os.setf(ios::fixed, ios::floatfield); 
    os << "(" << p.x << ", " << p.y << ")"; 
    os.unsetf(ios::showpos);
    os.setf(ios::floatfield);
    return os;
}    


ostream& operator<<(ostream& os, Line& p) {
    for(Point2List::iterator ii = p.points.begin(); ii != p.points.end(); ii++) {
	if (ii != p.points.begin()) {
	    os << ", ";
	}	
	os << *ii;
    }
    
    return os;
}


// error message
void error(const string& msg, const string& param = "") {
    cerr << "error: " << msg << " " << param << "\n";
    exit(1);
}


void log(const string& msg, const string& param = "") {
    cerr << "log: " << msg << " " << param << "\n";
}


inline bool read(istream& is, float& f) {
    float ff;
    
    if (is >> ff) {
	f = ff / 1000000;
	return true;
    } else {
	return false;
    }
}


inline bool read_x(istream& is, float& f) { 
    
    if (read(is, f)) {
	if (f >= 100) {
	    f = -f;	    
	}
	return true;
    }

    return false;
}

inline bool read_y(istream& is, float& f) {
    return read(is, f);
}


// parses a line, returning a pointer to a list of points from that line
Line* loadLine(const string& s) {
    istringstream iss(s);
    
    Line *l = new Line();
    
    for (;;) {
	float x, y;

	if (!(read_x(iss, x) && read_y(iss, y))) {
	    break;
	}
	
	l->points.push_back(Point2(x, y));	
    }

    return l;
}


// parses input file, populating global variables pmin, pmax and allpoints
State* loadState(const string& file) {
    log("loading " + file);

    ifstream from(file.c_str());
    
    if (!from) {
	error("error opening file", file);
    }
    
    State *s = new State();
    
    // read first four numbers
    if (!(read_x(from, s->min.x) && 
	  read_x(from, s->max.x) && 
	  read_y(from, s->min.y) && 
	  read_y(from, s->max.y))) {
	
	error("error reading bounding coordinates");
    }
    
    // read the rest, line by line
    string ss;
    while (getline(from, ss)) {
	s->lines.push_back(loadLine(ss));
    }
        
    from.close();
    
    return s;
}


Country* loadCountry(StringList& files) {
    Country *c = new Country();

    for (StringList::iterator ii = files.begin(); ii != files.end(); ii++) {
	c->addState(loadState(*ii));
    }

    return c;
}
