#ifndef __STATE_H__
#define __STATE_H__

#include <vector>
#include "Line.h"
#include "Point2.h"

#define MAX(x, y) ((x) > (y) ? (x) : (y));
#define MIN(x, y) ((x) < (y) ? (x) : (y));

class State {
 public:
    Point2 max;
    Point2 min;
    LineList lines;


    void checkBounds(Point2& p) {
	if (max.isZero() && min.isZero()) {
	    max = min = p;
	} else {
	    max.x = MAX(max.x, p.x);
	    max.y = MAX(max.y, p.y);
	    min.x = MIN(min.x, p.x);
	    min.y = MIN(min.y, p.y);
	}
    }


    void addLine(Line *l) {
	for (Point2List::iterator jj = l->points.begin(); jj != l->points.end(); jj++) {
	    checkBounds(*jj);
	}

	lines.push_back(l);
    }


    State() {}


    State(LineList& ll) {
	for (LineList::iterator ii = ll.begin(); ii != ll.end(); ii++) {
	    addLine(*ii);
	}
    }
};


#endif // __STATE_H__
