#ifndef __POINT2_H__
#define __POINT2_H__

/*
 * This class is based on Point2 described in the textbook. Additions
 * include constructors and methods required for storing points in C++
 * datastructures.
 */
class Point2{ // for 2D points with real coordinates
public:
	float x,y;
	void set(float dx, float dy){x = dx; y = dy;}
	void set(Point2& p){ x = p.x; y = p.y;}

	Point2(float xx, float yy){x = xx; y = yy;}
	Point2() {x = y = 0;}

	// copy constructor
	Point2(const Point2& p) { x = p.x; y = p.y; }

	// copy in assignment
	Point2& operator=(const Point2& p) { x = p.x; y = p.y; return *this; }

	// comparison ops
	bool operator==(const Point2& p) const { return x == p.x && y == p.y; }
	bool operator!=(const Point2& p) const { return !operator==(p); }
	bool operator<(const Point2& p) const { return x < p.x; }

	bool isZero() { return x == 0 && y == 0; }

	Point2 translate(float dx, float dy) {
	    return Point2(x + dx, y + dy);
	}
};

#endif // __POINT2_H__
