#ifndef _RGBPIXMAP
#define _RGBPIXMAP

#include <string>
#include <GL/glut.h>

typedef unsigned char uchar;


class IntPoint { 
    // for 2D points with integer coordinates
 public: 
    int x,y;
    void set(int dx, int dy) {x = dx; y = dy;}
    void set(IntPoint& p){ x = p.x; y = p.y;} 
    IntPoint(int xx, int yy) {x = xx; y = yy;}
    IntPoint() { x = y = 0;}
};


class mRGB{   
 public: 
    uchar r, g, b;
    mRGB() { r = g = b = 0; }
    mRGB(mRGB& p) {r = p.r; g = p.g; b = p.b;}
    mRGB(uchar rr, uchar gg, uchar bb) {r = rr; g = gg; b = bb;}
    void set(uchar rr, uchar gg, uchar bb) {r = rr; g = gg; b = bb;}
};


class RGBpixmap{
 public:
    int nRows, nCols; // dimensions of the pixmap
    mRGB* pixel; // array of pixels
    
    RGBpixmap() { nRows = nCols = 0; pixel = 0; }

    RGBpixmap(int rows, int cols) {
	nRows = rows;
	nCols = cols;
	pixel = new mRGB[rows*cols]; 
    }
    
    ~RGBpixmap() {
	delete [] pixel; 
    }
    

    void copy(int x, int y, int width, int height) { 	
	if(nRows == 0 || nCols == 0) return;
	glCopyPixels(x, y, width, height, GL_COLOR);
    }


    void draw() { 	
	if(nRows == 0 || nCols == 0) return;	
	//tell OpenGL: don't align pixels to 4 byte boundaries in memory
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	glDrawPixels(nCols, nRows, GL_RGB, GL_UNSIGNED_BYTE, pixel);
    }

	
    void draw(int x, int y) {
	// (x,y) is the origin of the translated image to be drawn
	// 4 cases, depending on which quadrant (x,y) is in
	if (x >= 0 && y >= 0) {	// drag left and down
	    glRasterPos2i(0, 0);
	    glPixelStorei(GL_UNPACK_SKIP_ROWS, y);
	    glPixelStorei(GL_UNPACK_SKIP_PIXELS, x);
	    glDrawPixels(nCols - x, nRows - y, GL_RGB,
			 GL_UNSIGNED_BYTE,pixel);
	    
	} else if (x >= 0 && y < 0) { // drag left and up
	    glRasterPos2i(0, -y);
	    glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
	    glPixelStorei(GL_UNPACK_SKIP_PIXELS, x);
	    glDrawPixels(nCols - x, nRows + y, GL_RGB,
			 GL_UNSIGNED_BYTE,pixel);
	    
	} else if (x < 0 && y >= 0) { // drag right and down
	    glRasterPos2i(-x, 0);
	    glPixelStorei(GL_UNPACK_SKIP_ROWS, y);
	    glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);
	    glDrawPixels(nCols + x, nRows - y, GL_RGB,
			 GL_UNSIGNED_BYTE,pixel);
	
	} else { // (x < 0 && y < 0), drag right and up
	    glRasterPos2i(-x, -y);
	    glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
	    glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);
	    glDrawPixels(nCols + x, nRows + y, GL_RGB,
			 GL_UNSIGNED_BYTE,pixel);
	}
    }

   
    int read(int x, int y, int wid, int ht) { 
	// read a rectangle of pixels into this pixmap
	nRows = ht;
	nCols = wid;
	
	if (pixel) {
	    delete[] (pixel);
	}
	
	pixel = new mRGB[nRows *nCols]; 
	if(!pixel) return -1;
	
	//tell OpenGL: don't align pixels to 4 byte boundaries in memory
	glPixelStorei(GL_PACK_ALIGNMENT, 1);
	glReadPixels(x, y, nCols, nRows, GL_RGB,GL_UNSIGNED_BYTE, pixel);
	return 0;
    }
    
    void setPixel(int x, int y, mRGB color) {
	if(x >= 0 && x < nCols && y >= 0 && y < nRows) {
	    pixel[nCols * y + x] = color;
	}
    }
    
    mRGB getPixel(int x, int y) { 		
	mRGB bad(255, 255, 255);
	assert(x >= 0 && x < nCols);
	assert(y >= 0 && y < nRows);
	return pixel[nCols * y + x];
    }    


    int writeBMPFile(const char *fname);
    int readBMPFile(const char *fname);
}; 

#endif // _RGBPIXMAP
