#include "hw3.h"

inline bool insideBox(Point2& p, Point2& a, Point2& b) {
    return (p.x >= a.x && p.x <= b.x && p.y >= a.y && p.y <= b.y);
}


Box SimpleLineFinder::getBoundaries() {
    return Box(state->min, state->max);
}


LineList *SimpleLineFinder::findLines(Box& box) {
    LineList *ll = new LineList();
    Point2 min = box.min();
    Point2 max = box.max();


    // log("finding candidates");

    for (LineList::iterator ii = state->lines.begin(); ii != state->lines.end(); ii++) {
	Line *l = *ii;

	for (Point2List::iterator jj = l->points.begin(); jj != l->points.end(); jj++) {
	    if (insideBox(*jj, min, max)) {
		ll->push_back(l);
		break;
	    }
	}
    }

    // cerr << "found " << ll->size() << endl;

    return ll;
}


LineList *CachedLineFinder::findLines(Box& box) {
    // search cache
    for (Cache::iterator ii = cache.begin(); ii != cache.end(); ii++) {
	Pair p = *ii;
	if (p.box.contains(box)) {
	    return p.lines;
	}
    }

    LineList *ll = realFinder->findLines(box);

    if (cache.size() >= maxSize) {
	cache.pop_back();
    }

    Pair p;
    p.box = box;
    p.lines = ll;

    cache.insert(cache.begin(), p);
    // cerr << "new cache size is " << cache.size();

    return ll;
}
