#ifndef __LINE_H__
#define __LINE_H__

#include <vector>
#include "Point2.h"

// list of Point2 typedef - to improve readability
typedef vector<Point2> Point2List;

class Line {
 public:
    Point2List points;
};

// list of line pointers
typedef vector<Line*> __LineList;


class LineList {
 protected:
    bool freeLines;
    __LineList list;

 public:
    LineList(bool freeLines = false) {
	this->freeLines = freeLines;
    }


    ~LineList() {
	if (freeLines) {
	    for (LineList::iterator ii = list.begin(); ii != list.end(); ii++) {
		delete(*ii);
	    }
	}
    }


    typedef __LineList::iterator iterator;

    void push_back(Line *l) {
	list.push_back(l);
    }

    iterator begin() {
	return list.begin();
    }

    iterator end() {
	return list.end();
    }

    void insert(iterator a, iterator b, iterator c) {
	list.insert(a, b, c);
    }

    int size() {
	return list.size();
    }

};

#endif
