#ifndef __BOX_H__
#define __BOX_H__

#include <vector>
#include "Point2.h"

class Box;

// list of Boxes
typedef vector<Box> BoxList;

class Box {
 public:
    Point2 p;
    float width;
    float height;


    Box() {
	p = Point2();
	width = 0;
	height = 0;
    }


    Box(Point2 p, float width, float height) {
	this->p = p;
	this->width = width;
	this->height = height;
    }


    Box(Point2& min, Point2& max) {
	this->p = min;
	this->height = max.y - min.y;
	this->width = max.x - min.x;
    }


    Point2 min() const {
	return p;
    }


    Point2 max() const {
	return Point2(p.x + width, p.y + height);
    }


    // comparison ops
    bool operator==(const Box& box) const {
	return box.p == p &&
	    box.width == width &&
	    box.height == height;
    }

    bool operator!=(const Box& box) const { return !operator==(box); }
    bool operator<(const Box& box) const { return p < box.p; }

    BoxList intersection(float dx, float dy);

    bool contains(const Box& box) {
	Point2 mymax = this->max();
	Point2 bmax = box.max();

	return (p.x <= box.p.x &&
		p.y <= box.p.y &&
		mymax.x >= bmax.x &&
		mymax.y >= bmax.y);
    }
};


ostream& operator<<(ostream& os, Box& b);

#endif // __BOX_H__
