#include <cmath>
#include <iostream>

#include "hw3.h"

#define MAX(x, y) ((x) > (y) ? (x) : (y));
#define MIN(x, y) ((x) < (y) ? (x) : (y));


ostream& operator<<(ostream& os, Box& box) {
    Point2 a = box.min();
    Point2 b = box.min();

    return os << "(" << a << ", " << b << ")";
}	


BoxList Box::intersection(float dx, float dy) {
    Box v;
    Box h;

    // cerr << dx << " " << dy << endl;
        
    float adx = abs(dx);
    float ady = abs(dy);

    float nwidth = width - adx;
    float nheight = height - ady;

    if (dx >= 0 && dy >= 0) {	
	v = Box(p, adx, height);	
	h = Box(p.translate(adx, 0), nwidth, ady);
	
    } else if (dx >= 0 && dy < 0) { 
	v = Box(p, adx, height);
	h = Box(p.translate(adx, nheight), nwidth, ady);
	
    } else if (dx < 0 && dy >= 0) {
	v = Box(p.translate(nwidth, 0), adx, height);
	h = Box(p, nwidth, ady);

    } else { // (dx < 0 && dy < 0)
	v = Box(p.translate(nwidth, 0), adx, height);
	h = Box(p.translate(0, nheight), nwidth, ady);
    }
    
    BoxList bl;
    
    // cerr << v << " -- " << h << endl;
    
    if (v.width > 0 && v.height > 0) {
	bl.push_back(v);
    }

    if (h.width > 0 && h.height > 0) {
	bl.push_back(h);
    }

    return bl;
}
