/* file: the.h
 *
 * Code for the Toy HardwarE (THE), 
 * a simulated architecture supporting variable-length partitions.
 * We refer to this hardware as ``THE machine''.
 *
 * FOR MOST OF OUR PROJECTS, YOU MUST NOT MODIFY THIS CODE
 * AS IT REPRESENTS OUR HARDWARE.
 *
 * THIS CODE IS modified from the original stm.c code,
 * 	with permission from Professor Ernie Davis 
 * 	The original stm.c file is split into a hardware
 * 	part and an OS part, represented by the four files
 * 	
 * 		the.h,  the.c, tos.h, tos.c.
 *
 * Fall 2006, Fall 2007: Operating Systems Class, Professor Yap
 *
 ***************************************************/

#ifndef H_THE
#define H_THE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define RAMSIZE 262144	// 2**18 address space
#define NUMREGS 16

/****************************************************
 * Error Codes 
 ****************************************************/

#define ERR_DIV_BY_0 0
#define ERR_OVERFLOW 1
#define ERR_ADDR 2
#define ERR_PC 3
#define ERR_INPUT 4
#define ERR_OUTPUT 5

/****************************************************
 * Global variables for the simulated architecture
 ****************************************************/

extern int
      mem[RAMSIZE],	    // Core memory
      regs[NUMREGS],	    // general registers
      base,         	    // Base register
      limit,        	    // limit register
      error; 		    // Error status flag (or register)
      
extern char codes[16][4];   // Op codes 
     
/****************************************************
 * Other global variables 
 ****************************************************/

#define MAXBUF 128	    // Buffer size for string I/O traps

extern int
     debug,                 // Level of debugging
     terminate,		    // Termination flag
     maxinst;  		    // Maximum number of instructions

// N.B. The following ought to belong to tos.h, but for
// debugging purposes, and extensions, we put it here:

#define NAMESIZE 32	// maximum size of process name
extern int     procindex;      /* Index of process */
extern char procname[NAMESIZE];  /* name of process */

/****************************************************
 * int the_err(char msg[])
 *
 * 	Print an error message (msg) with error code e
 ****************************************************/

extern int the_err(int e, char msg[]);

/****************************************************
 * int phys_address(int reladd)
 * 
 * 	Convert a relative address to a physical address.
 *	Check that it lies within bounds 
 ****************************************************/

extern int phys_address(int reladd);


/****************************************************
 * void show_inst(op, ra, ad, rb, rc, rd);
 *
 *	Display STM instruction for level-2 debugging 
 ****************************************************/

extern void show_inst(int op, int ra, int ad, int rb, int rc, int rd);


/****************************************************
 * void get_inst(inst, pop, pra, pad, prb, prc, prd);
 *
 *	Decompose an STM instruction into its components
 ****************************************************/

extern void get_inst(int inst,
	int* pop, int* pra, int* pad, int* prb, int* prc, int* prd);


/****************************************************
 * int exec_inst(op, ra, ad, rb, rc, rd);
 *
 *	Executes an STM instruction.
 *	This does the actual work of the STM code
 ****************************************************/

extern int exec_inst(int op, int ra, int ad, int rb, int rc, int rd);

/****************************************************
 * void exec_trap();
 * 
 * 	Execute a trap
 ****************************************************/

extern void exec_trap();
 
/****************************************************
 * void exec_stm();
 *
 * 	The main loop of THE machine:
 * 	infinite loop to execute each instruction of STM code
 ****************************************************/

extern void exec_stm();

#endif
// END of the.h
