/*  
 *  file: tos.h
 *  This is header file for
 *  the bare-bones Toy Operating System (TOS)
 *  designed to operate the THE machine.
*/

#include "the.h"	// include THE Machine


/****************************************************
 * int parse_flags(argc, argv)
 *
 *	Extract the flags from command line:
 *		base, debug, and maxinst.
 *	The index of the STM filename in the command
 *		is returned as the value.
 ****************************************************/

extern int parse_flags(int argc, char * argv[]);

/****************************************************
 * void load_stm(filename);
 *
 *	Load the STML code into memory 
 *	It is assumed that STML files are correctly formatted;
 * 	therefore, this does no error checking
 ****************************************************/

extern void load_stm(char filename[]);

/****************************************************
 * void initialize(argc, argv);
 *
 *	Set global flags,
 *	load the STM file,
 *	initialize the STM process
 ****************************************************/

extern void initialize(int argc, char* argv[]);

  
/***************************************************
 * THE END
 ***************************************************/

