/*  
 *  file: sos.c
 *  This is the bare-bones Toy Operating System (TOS)
 *  designed to operate the THE machine.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tos.h"	// This also include "the.h"

/****************************************************
 * Global Variables for processes
 ****************************************************/
// N.B. These are already in the.c:

//int     procindex = 0;      /* Index of process */
//char procname[NAMESIZE];  /* name of process */

/****************************************************
 * int parse_flags(argc, argv)
 *
 * 	PARSING for tos arguments 
 ****************************************************/

int parse_flags(int argc, char* argv[])

{ int ibase = 0, idebug = 0, imax=0, ifilename=1;
            /* Positions of arguments in command line */
  int i;

  for (i=1; i<9; i=i+2) {
     if (argv[i][0] == '-') 
        switch (argv[i][1]) {
           case 'b': ibase = i+1; break;
           case 'd': idebug = i+1; break;
           case 'm': imax = i+1; break;
          }
     else {
       ifilename = i;
       break;
       }
    }
  if (ibase) base=atoi(argv[ibase]);
  if (idebug) debug=atoi(argv[idebug]);
  if (imax) maxinst=atoi(argv[imax]);
  return(ifilename);
}


/* Load the STML code into memory */
/* It is assumed that STML files are correctly formatted; therefore,
   this does no error checking */

void load_stm(char filename[])
{ int count = base,	// Address 
      inst;  		// Instruction
  char line[240];	// max length of line in STM file
  int i;
  FILE *fp;

  fp = fopen(filename, "r");            // Open the STM file
  if (fp == NULL)
    tos_error(1, "File name error %s\n", filename);

  fgets(procname, NAMESIZE, fp); 	// read process name
  procname[strlen(procname)-1] = '\0';  // get rid of carriage return at end
  fgets(line,240,fp);            	// read length of partition
  limit=atoi(line);
  if (debug == 2) { 
     printf("Process %s index %i loading from base %i length %i\n", 
            procname, procindex, base, limit);
     printf("Physical address / Virtual address / Instruction\n");
   }
  while (!feof(fp)) {             /* read code and load into memory */
      fgets(line,240,fp);
      if (isdigit(line[0])) {
         sscanf(line, "%i", &mem[count]);
         count++;
        }
    }
  if (debug==2)
     for (i=base; i<count; i++) printf("Ox%x 0x%x 0x%x\n",i, i-base, mem[i]);
  fclose(fp);
}

/***************************************************
 * void initialize(argc, argv)
 *
 * Set global flags, load the STM file, initialize the STM process
 ***************************************************/

void initialize(int argc, char* argv[])

{ FILE *fp;
  int ifilename, i;
  
  for (i = 0; i < NUMREGS; i++) regs[i] = 0;
  for (i = 0; i < RAMSIZE; i++) mem[i] = 0;
  ifilename = parse_flags(argc,argv);
  load_stm(argv[ifilename]);
}

/***************************************************
 * tos_error(errno, msg)
 *
 * 	Prints error message, and sets error=errno.
 ***************************************************/
int tos_error(int errno, char msg[]){
	error=errno;
	printf(msg);
}
  
/***************************************************
 * main: initialize, load, execute 
 ***************************************************/

int main(int argc, char * argv[])
{ int i;
  
  initialize(argc,argv);
  for (i=0; !error && !terminate && (i != maxinst); i++)
	  exec_stm();
  return 0;
}

/***************************************************
 * THE END
 ***************************************************/

