/* parser.c
 *
 * -- parser is for parsing command lines
 * -- the header file for parser.c is tsh.h
 * 
 * Routines in this file:
 *	int parser(char [], char *[], int*)
 *	int showargs(char [], char *[])
 *	void syserr(char* msg){
 ***************************************************/

#include <stdio.h>
#include <unistd.h>

#define MAX_LINE 80 /* 80 chars per line as in standard screen widths */

/**
 * int parser(inputBuffer, args, background)
 *	takes a command line in inputBuffer,
 *		viewed as tokens separated by white spaces.  
 *	It outputs the tokens in the array *args[],
 *		with a NULL token indicating the end of array.  
 *	If the command line ends in the token "&",
 *		it sets the background variableto 1.
 *	It returns the number of tokens (not counting the NULL one)
 */

int parser(char inputBuffer[], char *args[],int *background)
{
    int length, /* # of characters in the command line */
        i,      /* loop index for accessing inputBuffer array */
        start,  /* index where beginning of next command parameter is */
        ct;     /* index of where to place the next parameter into args[] */
    
    ct = 0;
    
    /* read what the user enters on the command line */
    length = read(STDIN_FILENO, inputBuffer, MAX_LINE);  

    start = -1;
    if (length == 0)
        exit(0);            /* ^d was entered, end of user command stream */
    if (length < 0){
        perror("error reading the command");
	exit(-1);           /* terminate with error code of -1 */
    }

    /* examine each character in the inputBuffer */
    for (i=0;i<length;i++) { 
        switch (inputBuffer[i]){
	    case ' ':
	    case '\t' :               /* argument separators */
		if(start != -1){
                    args[ct] = &inputBuffer[start];    /* set up pointer */
		    ct++;
		}
                inputBuffer[i] = '\0'; /* add a null char; make a C string */
		start = -1;
		break;

            case '\n':                 /* should be the final char examined */
		if (start != -1){
                    args[ct] = &inputBuffer[start];     
		    ct++;
		}
                inputBuffer[i] = '\0';
                args[ct] = NULL; /* no more arguments to this command */
		break;

	    default :             /* some other character */
		if (start == -1)
		    start = i;
                if (inputBuffer[i] == '&'){
		    *background  = 1;
                    inputBuffer[i] = '\0';
		}
	} 
     }    
     args[ct] = NULL; /* just in case the input line was > 80 */
     return(ct);
}//parser 

// show args (first print message)
int showargs(char * msg, char *argv[])
{
	int i = 0;
	printf(msg);
	while (argv[i] != NULL) {
		printf("arg[%d] = %s\n", i, argv[i]);
		i++;
	}
	return i;
}//showargs

//void syserr(char* );  /* error report, abort routine */ 
void syserr(char* msg){
  printf(msg);
}//syserr

