
;************************************************************************
; Read attributes of character at Row, Column and return it in AX       *
; Entry: The follwing parameters are passed on the stack as words       *
;        Row, Col                                                       *
; Exit:  AX       Backgrouond and foreground colors packed into a byte  *
;************************************************************************

Row     EQU     [BP+4]
Column  EQU     [BP+6]

        PUBLIC _Read_Attribute

_Read_Attribute PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    DI                      ;Preserve registers
        PUSH    ES

        ;--- Convert row and column to absolute offset within display buffer

        XOR     AX,AX                   ;Point ES to segment zero
        MOV     ES,AX
        MOV     AX,Row                  ;Fetch row number
        MOV     BX,ES:[BIOS_Columns]    ;Fetch columns per screen
        MUL     BX                      ;Compute absolute address as
        ADD     AX,Column               ; Column + Row * Columns)
        SHL     AX,1                    ; Account for attributes
        MOV     DI,AX                   ;Move address into register DI
        INC     DI                      ;Skip character code byte

        ;--- Determine and load segement of the display buffer

        MOV     AX,0B000H               ;Assume monochrome buffer address
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono attached?
        JNZ     Attr_Read_Ok            ;...Yes, go load segment
        MOV     AX,0B800H               ;...No, change address to color
Attr_Read_Ok:
        MOV     ES,AX                   ;Set segment of display buffer

        ;--- Fetch the attribute and return it

        MOV     AL,ES:[DI]              ;Fetch the attribyte
        XOR     AH,AH                   ;Clear upper byte of return value

        POP     ES                      ;Restore registers
        POP     DI
        MOV     SP,BP
        POP     BP
        RET
_Read_Attribute ENDP
