
;************************************************************************
; Select 43 line text mode it is assumed that an 8x8 character          *
; generator has been already downloaded                                 *
; This is an example how to set control registers for different         *
; character heights.                                                    *
;************************************************************************

CHAR_HITE       EQU     8

        PUBLIC  _Set_43_Lines

_Set_43_Lines   PROC    NEAR
        PUSH    ES
        XOR     AX,AX                   ;Point ES to segment zero
        MOV     ES,AX

        ; Set underline location in CRTC 14 to 8

        MOV     DX,ES:[BIOS_CRT_Addr]   ;Fetch address of CRT controller
        MOV     AL,14H                  ;Index for UNDERLINE LOCATION
        OUT     DX,AL                   ;Select UNDERLINE REGISTER
        INC     DX
        MOV     AL,CHAR_HITE            ;Fetch value for underline
        OUT     DX,AL                   ;Set UNDERLINE register
        DEC     DX

        ; Set character height in CRTC 9 to 7

        MOV     AL,9                    ;Index for CHARACTER HEIGHT
        OUT     DX,AL                   ;Select register for write
        INC     DX
        MOV     AL,CHAR_HITE-1          ;Value is 7
        OUT     DX,AL                   ;Write value into register
        DEC     DX

        ; Set vertical display end in CRTC 12 to 43*8-1
        ; (upper bit in overflow already set)

        MOV     AL,12H                  ;Select index
        OUT     DX,AL
        INC     DX
;       MOV     AL,(43*8-1-256)         ;Write value
        MOV     AL,((350/CHAR_HITE)*CHAR_HITE-1-256)
        OUT     DX,AL

        ; Reset constants in segment zero to reflect new dimensions

        MOV     BYTE PTR ES:[BIOS_Rows],(350/CHAR_HITE)-1
        MOV     WORD PTR ES:[BIOS_Columns],80
        MOV     WORD PTR ES:[BIOS_Height],CHAR_HITE

        ; We are forced here to use BIOS function to put 8x8 character
        ; set into plane 2, since we do not have our set to load

        MOV     AX,1112H                ;Function = Load 8x8 character set
        MOV     BL,0                    ;           into first block
        INT     10H                     ;Ask BIOS to use its ROM set


        POP     ES
        RET
_Set_43_Lines   ENDP
