
;************************************************************************
; Replace first 32 characters of character generator                    *
; with a box, using the BIOS function 11hex                             *
;************************************************************************

Box     DB      0FFH,081H,081H,081H, 081H,081H,081H,0FFH

        PUBLIC  _BIOS_Write_CG

_BIOS_Write_CG  PROC NEAR
        PUSH    BP
        PUSH    ES

        LEA     BP,Box                  ;Offset of new bitmap
        MOV     AX,CS                   ;Segement of new bitmap into ES
        MOV     ES,AX
        MOV     CX,1                    ;Do one character at a time
        MOV     DX,0                    ;Start with character 0
        MOV     BL,0                    ;Change table 0
        MOV     BH,8                    ;8 bytes per character
Replace_Loop:
        MOV     AH,11H                  ;Function = LOAD CHARACTER GENERATOR
        MOV     AL,00H                  ;Subfunction = CUSTOM CHAR GEN
        INT     10H                     ;Use BIOS to replace next character
        INC     DX                      ;Point to the next character to replace
        CMP     DX,32                   ;Are we done with all 32 characters?
        JB      Replace_Loop            ;...No, go do next one

        POP     ES
        POP     BP
        RET
_BIOS_Write_CG  ENDP
