
;************************************************************************
; Set cursor size by writing to CRTC registers                          *
; Entry:        Start - Starting line for cursor                        *
;               Stop  - Ending line for cursor                          *
;************************************************************************

Start   EQU     [BP+4]
Stop    EQU     [BP+6]

        PUBLIC  _Set_Cursor_Size


_Set_Cursor_Size PROC    NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES                      ;Preserve ES
        XOR     AX,AX                   ;Select segment zero
        MOV     ES,AX

        MOV     AL,Start                ;Update BIOS data area vars.
        MOV     ES:[BIOS_Curs_Start],AL ;To contain the new cursor shape
        MOV     AL,Stop
        MOV     ES:[BIOS_Curs_Stop],AL

        MOV     DX,ES:[BIOS_CRT_Addr]   ;Load CRTC address
        MOV     AL,0AH                  ;Fetch index of cursor start
        OUT     DX,AL                   ;Select index
        INC     DX                      ;Load CRTC address
        MOV     AL,Start                ;Fetch data value
        OUT     DX,AL                   ;Write the cursor start

        DEC     DX                      ;Load CRTC address
        MOV     AL,0BH                  ;Fetch index of cursor stop
        OUT     DX,AL                   ;Select index
        INC     DX                      ;Load CRTC address
        MOV     AL,Stop                 ;Fetch data value
        OUT     DX,AL                   ;Write cursor stop value

        POP     ES                              ;Restore ES
        POP     BP
        RET
_Set_Cursor_Size ENDP
