
;************************************************************************
; Set cursor size using a BIOS function                                 *
; Entry:        Start - Starting scan line (0 is at the top)            *
;               Stop  - Ending scan line for cursor                     *
;************************************************************************

Start   EQU     [BP+4]
Stop    EQU     [BP+6]

        PUBLIC  _BIOS_Set_Curs_Size

_BIOS_Set_Curs_Size PROC NEAR
        PUSH    BP
        MOV     BP,SP
        MOV     AH,01H                  ;Load BIOS function
        MOV     CH,Start                ;Start line for cursor
        MOV     CL,Stop                 ;End line for cursor
        INT     10H                     ;Call BIOS so set shape
        POP     BP
        RET
_BIOS_Set_Curs_Size ENDP
