
;************************************************************************
; Set current cursor position using BIOS call                           *
; Entry:        Row     - Row for the cursor                            *
;               Column  - Column for the cursor                         *
;************************************************************************

Row     EQU     [BP+4]
Column  EQU     [BP+6]

        PUBLIC  _BIOS_Set_Curs_Pos

_BIOS_Set_Curs_Pos   PROC NEAR
        PUSH    BP
        MOV     BP,SP
        MOV     AH,02H                  ;Load BIOS function
        MOV     BH,0                    ;Specify current page to be 0
        MOV     DH,Row                  ;Load desired row
        MOV     DL,Column               ;Load desired column position
        INT     10H                     ;Call BIOS so set position
        POP     BP
        RET
_BIOS_Set_Curs_Pos   ENDP
