title Graph12	(graphics mode 12h)
comment+ from p.181, Abel
	-- .com format
	-- save orig mode
	-- set mode 12h (vga color, 640x480, 16 of 256K colors)
	-- background green
	-- write pixel dots for rows 70-280, cols 64-576
	-- colors cycle with the rows
end comment+
if1
	include mymac.lib
endif
;
backgdColor	equ 13	; 7=gray, 13=light magenta
startrow	equ 70
endrow		equ 325
startcol	equ 64
endcol		equ 576
skipsize	equ 15	; is 15 pixels enough?
;
.sall		; suppress macro listing
.model small
.code
	org 100h
start:	jmp main
	color	label word
	lowcolor db 0f0h	; initially color 15 (f)
	hicolor	db 0
main	proc near
	mov ah,0fh	; get orig mode
	int 10h
	push ax		;   and save it
	;----------------------------------
	call mode	; set graphics mode
	call disp	; display color graphics
	call keyb	; get keyboard response
	;----------------------------------
	pop ax		; restore orig mode
	mov ah,00h
	int 10h
	exitdos		; macro
main 	endp
;
;	SET GRAPHICS MODE
;	-----------------
mode	proc
	mov ah,0	; int 10h, fcn 0=set mode
	mov al,12h	; vga graphics mode
	int 10h
	mov ah,0bh	; int 10h, fcn 0bh=set color palette
	mov bh,0	; set background color
	mov bl,backgdColor	; gray=7
	int 10h
	ret
mode 	endp
;
;	DISPLAY GRAPHIC DOTS
;	--------------------
disp	proc
	mov bx,0	; set initial page
	mov cx,startcol	
	mov dx,startrow	;   and row and cols
  again:
	mov ah,0ch	; int 10h, fcn 0ch=write pixel
	mov bx,color
	shr bx,4	; change colors only every 2^4=16 times
	mov al,bl	; set color
	xor bh,bh	; set page 0
	int 10h		; bx,cx,dx preserved
	inc cx		; next col
	cmp cx,endcol	; reach last col?
	jne again	; no, again
	mov cx,startcol	; yes, reset col
	inc color	; next color
	inc dx		; next row
	cmp dx,endrow	; reach last row?
	jbe again	; no, again
	ret		; yes, done!
disp	endp
;
;	DELAY, WAIT FOR KEYBOARD ENTRY
;	------------------------------
keyb	proc
	mov ah,10h	; int 16h, fcn 10h=get keybd input
	int 16h
	ret
keyb	endp
;
	end main