COMMENT +
	HW2
	Procedure div10
		Input: [SI] gives the address of a BigBin P
		Output: [DI] is the BigBin Q that contain
			the quotient of P/10, and AH has the
			remainder of P/10.
		Method:
			We have to be careful because SI and DI
				may be the same.
			Starting at the MSB of P, we divide
			each byte by 10, push the quotient
			on the stack and add the remainder to
			the next byte, and repeat.  At the
			end, the final remainder is what we
			want.  Also, we start to pop the
			quotients to [DI].  
END COMMENT +

Ten DB 10

Div10 Proc
  ; Begin by saving registers (using macro)
  save_regs <si,di,bx,cx,dx>            ; we do not save ax!
; put length of P into cx and dx:
  mov cl,[si]   ; cl has length of P
  xor ch,ch     ; cx has length of P
  mov dx,cx     ; dx has length of P
; make si point to MSB of P
  mov al,[si]
  neg al
  add al,40
  cbw
  add si,ax     ; now [si] is the MSB of P
; set up for the first division by putting the MSB of P into ax
  mov al,[si]
  xor ah,ah     ; ax has the MSB
DivAgain:
  div Ten       ; al=quotient q, and ah=remainder r.
  push ax       ; we only want al, but save ah anyway
  xor al,al     ; now ax has 256r.
  inc si        ; [si] has the next byte
  mov bl,[si]   ; bl has the next byte
  xor bh,bh     ; bx has the next byte
  add ax,bx     ; ax has 256r + b
  loop DivAgain
;; at this point, ah has the remainder we want
;; and the quotient of P/10 is on the stack.
;
; Now, mov the quotient into Q=[DI]
  mov cx,dx     ; now cx has the original length of P
  add di,40     ; now di points to the byte past the LSB of Q
PopAgain:
  pop bx
  dec di
  mov [di],bl
  loop PopAgain
;; at this point, the quotient is in Q but
;; the true length of Q may be somewhat less than dx.
;; We fix this length:
DecAgain:
  test [di], BYTE PTR 0FFh
  jne Finish
  dec dx
  inc di
  jmp DecAgain
Finish:
; At this point, dx (and dl) has the true length of Q
; However, if dl=0, we want to set dl=1
  mov al,dl              ; move the true length of Q to al
  cmp al,0               ; if al=0
  jne restore
  mov al,1               ; then we set al=1
restore:
  restore_regs <dx,cx,bx,di,si>
  mov [di],al           ; [di] has the length of Q
			; and remember, ah has the remainder of
			; P/10, which is returned to the caller
  ret
Div10 endp

