title mse1.asm: display mouse cursor
;
; Basic testing of mouse interrupts (INT 33h)
; In this test, we display mouse at an initial cursor position
;       of (A,B).  Then we increment the x coord twice and increment 
;       the y coordinate once and
;       redisplay the mouse position.
; Z contains the number of times to do incrementing
; To slow things down, Y contains the counter for delay
.model small
.stack 100h
.data
        A dw 0  
        B dw 0          ; (A,B) is the initial mouse cursor position
        C db 150        ; how many times to display mouse cursor
        D dw 64000      ; delay factor  (64000 is the maximum value
                        ; that fits in a word!)
.code
include mac\mac.asm
main proc
; init
 init_ds        ; macro invoke
; save mode
 mov ah,0fh
 int 10h
 push ax
 push bx
; choose mode 13h
 mov ah,0
 mov al,13h
 int 10h
; set mouse at position (a,b)
 mov ax,4
 mov cx,a
 mov dx,b
 int 33h
AGAIN:
 mov ax,1
 int 33h        ; show cursor
; test if mouse button pressed
 mov ax,3
 int 33h
 xor bx,bx
 jnz Done
 inc A
 inc A          ; increment the horizontal position twice
 mov cx,A
 inc B          ; increment the vertical position once
 mov dx,B
 mov ax,4
 int 33h
 mov cx,D
DELAY:
 loop DELAY
 sub C,1
 jnz again
DONE:
; wait for key stroke to terminate program
 mov ah,0
 int 16h
; restore mode
 pop bx
 pop ax
 xor ah,ah
 int 10h
 mov al,bh
 mov ah,5
 int 10h
; dos return
 dos_rtn 0
main endp
 end main



