COMMENT+
	This is file hw2.asm,
        	-- sample solution for hw1 AND hw2
*************************************************************
        V22.0201.002, Machine Organization
        Fall 1997
*************************************************************

	(1) The Bug in H2.asm is that
		we used ``-bx'' in the based addressing
		mode.  This is not permitted, but unfortunately,
		the assembler does not catch this error.  The
		assembler simply treats this as ``+bx''.

	(2) HOW CAN YOU FIND THIS BUG?
		You first need to understand the intent of the
		original program.   Then you step through
		the program using debugger (I would set
		one breakpoint at the end of the reversal loop),
		and examining the contents of the Input Variable
		and registers, to see if it MEETS YOUR EXPECTATION.
		
	(3) The Fix:
		After you find the bug, you must figure out the fix.
		One way is to use another register (say DX)
		which stores the value 15-BX.  So when we
		increment BX, we must decrement DX.
		Then, we replace the original instruction

			xchg ax,[Input+15-bx]

		by three instructions

			xchg bx,dx
			xchg ax,[Input+bx]
			xchg bx,dx

		But a more elegant solution was found by some
		of you:  without using another register,
		simply replace 

			xchg ax,[Input+15-bx]

		by three instructions

			neg  bx
			xchg ax,[Input+15+bx]
			neg  bx


*************************************************************
	
        +
title hw1 and hw2 solution
.model small
.stack 100h
.data
CR equ 13
LF equ 10
Greeting db 'Welcome to my echo/reverse program!',CR,LF
        db 'Please type any 16 characters at the prompt. $'
Prompt  db CR,LF,'>>$'
Input   db 16 dup (?),'$'
EchoPrompt db CR,LF,'Here is your input: $'
RevPrompt  db CR,LF,'And its reversal:   $'
.code
main proc
;
mov ax,@data
mov ds,ax
;
; Print Greeting
        lea dx,Greeting
        mov ah,9
        int 21h
; Request Input
        lea dx,Prompt
        mov ah,9
        int 21h
; Read 16 characters
        mov cx,16
        mov bx,0
        mov ah,1                ; function 1 of int 21h (read char)
Again:
        int 21h                 ; read a character into al
        mov [bx+Input],al       ; save it in Input
        inc bx                  ; get ready for next input position
        loop Again
; Echo the input
        mov ah,9
        lea dx,EchoPrompt
        int 21h
        lea dx,Input
        int 21h
; Reverse the input
        mov cx,8
        mov bx,0
Repeat:
        mov ah,[Input+bx]
        neg bx                  ; inserted as fix
        xchg ah,[Input+bx+15]   ; replace -bx by +bx as fix (not really needed)
        neg bx                  ; inserted as fix
        xchg ah,[Input+bx]
        inc bx
        loop Repeat
; Print the reversed input
        mov ah,9
        lea dx,RevPrompt
        int 21h
        lea dx,Input
        int 21h
; DOS cleanup
        mov ax,4c00h
        int 21h
main endp
end main



