
;************************************************************************
; Restore screen from a file PICTURE.001                                *
; Assumes default settings of EGA registers for modes E,F,10            *
;************************************************************************

Load_Name       EQU     [BP+4]
Load_Handle     DW      0
Load_Counter    DB      0

        PUBLIC  _Screen_Load

_Screen_Load    PROC    NEAR
        PUSH    BP                      ;Standard high level entry
        MOV     BP,SP
        PUSH    DS                      ;Preserve DS

        ;--- Open the file

        MOV     DX,Load_Name            ;Fetch pointer to the file name
        MOV     CX,0                    ;Normal attribute for the file
        MOV     AH,3DH                  ;DOS function to open file
        MOV     AL,0                    ;Open file for READ
        INT     21H                     ;Ask DOS to open the file
        JC      Load_Error              ;Quit on open error
        MOV     Load_Handle,AX          ;Save the handle to the opened file

        ;--- Enable next plane and read 28,000 bytes into it

        MOV     Load_Counter,8          ;Initialize counter of planes done
        MOV     AX,0A000H               ;Point DS:DX to display buffer
        MOV     DS,AX
        MOV     DX,3C4H                 ;Select PLANE ENABLE register
        MOV     AL,2                    ;in SEQUENCER
        OUT     DX,AL
Load_Loop:
        MOV     AL,CS:Load_Counter      ;Select next plane for write
        MOV     DX,3C5H
        OUT     DX,AL
        XOR     DX,DX
        MOV     CX,28000                ;Number of bytes to read
        MOV     BX,CS:Load_Handle       ;File handle
        MOV     AH,3FH                  ;DOS function to read from a file
        INT     21H                     ;Ask DOS to read data from a file
        JC      Close_Load_File         ;Quit on error
        CMP     AX,28000
        JNE     Close_Load_File
        SHR     CS:Load_Counter,1       ;Check if all planes are done
        JNZ     Load_Loop               ;and if not go do next plane

        ;--- Close the file

Close_Load_File:
        MOV     BX,CS:Load_Handle       ;Fetch handle
        MOV     AH,3EH                  ;DOS function to close a file
        INT     21H                     ;Ask DOS to close the file
Load_Done:
        MOV     DX,3C4H                 ;Restore all four planes for write
        MOV     AL,2                    ;By loading PLANE ENABLE register
        OUT     DX,AL                   ;in the SEQUENCER
        INC     DX
        MOV     AL,0FH
        OUT     DX,AL

        POP     DS                      ;Restore DS
        POP     BP
        RET
Load_Error:                             ;This is where we can add error
        JMP     Load_Done               ;reporting
_Screen_Load    ENDP
