
;************************************************************************
; Display red character '9' on a blue background in the                 *
; middle of 80x25 screen using WRITE CHARACTER AND ATTRIBUTE            *
; function in the BIOS                                                  *
;************************************************************************

        PUBLIC _BIOS_Char_9

_BIOS_Char_9    PROC NEAR
        MOV     DH,12                   ;Select row 12
        MOV     DL,40                   ;Select column 40
        MOV     BH,0                    ;Use first page
        MOV     AH,2                    ;Function = SET CURSOR POSITION
        INT     10H                     ;Ask BIOS to set cursor position

        MOV     AL,'9'                  ;Will display character '9'
        MOV     BL,12H                  ;Set character attribute
        MOV     BH,0                    ;Use first page
        MOV     CX,1                    ;Do this character only once
        MOV     AH,9                    ;Function = WRITE CHAR & ATTRIB
        INT     10H                     ;Ask BIOS to display character
        RET
_BIOS_Char_9    ENDP

;************************************************************************
; Display the character 'A' (with attribute same as previous            *
; character in same position) using WRITE CHARACTER ONLY                *
; function in the BIOS                                                  *
;************************************************************************

        PUBLIC _BIOS_Char_A

_BIOS_Char_A    PROC NEAR
        MOV     DH,12                   ;Select row 12
        MOV     DL,41                   ;Select column 41
        MOV     BH,0                    ;Use first page
        MOV     AH,2                    ;Function = SET CURSOR POSITION
        INT     10H                     ;Ask BIOS to set cursor position

        MOV     AL,'A'                  ;Will display character 'A'
        MOV     BH,0                    ;Use first page
        MOV     CX,1                    ;Do this character only once
        MOV     AH,0AH                  ;Function = WRITE CHARACTER
        INT     10H                     ;Ask BIOS to display character
        RET
_BIOS_Char_A    ENDP

;************************************************************************
; Display the characters 'FNE' (with attribute same as                  *
; previous charcter in same position) using TELETYPE                    *
; function in the BIOS                                                  *
;************************************************************************

        PUBLIC _BIOS_Char_E

_BIOS_Char_E    PROC NEAR
        MOV     DH,13                   ;Select row 13
        MOV     DL,40                   ;Select column 40
        MOV     BH,0                    ;Use first page
        MOV     AH,2                    ;Function = SET CURSOR POSITION
        INT     10H                     ;Ask BIOS to set cursor position

        MOV     AL,'F'                  ;Will display character 'F'
        MOV     BH,0                    ;Use first page
        MOV     AH,0EH                  ;Function = TELETYPE
        INT     10H                     ;Ask BIOS to display character

        MOV     AL,'N'                  ;Will display character 'N'
        INT     10H                     ;Ask BIOS to display character

        MOV     AL,'E'                  ;Will display character 'E'
        INT     10H                     ;Ask BIOS to display character
        RET
_BIOS_Char_E    ENDP

;************************************************************************
; Display the characters 'F13' (with attribute same as                  *
; previous character in same position) using WRITE STRING               *
; function in the BIOS, with blue on red background                     *
;************************************************************************

        PUBLIC _BIOS_Char_13

TestChr DB      'FN13'

_BIOS_Char_13   PROC NEAR
        PUSH    ES
        PUSH BP

        MOV     DH,14                   ;Select row 14
        MOV     DL,40                   ;Select column 40
        MOV     BH,0                    ;Use first page
        MOV     CX,4                    ;Display four characters
        MOV     AX,CS                   ;Point ES:BP to the string
        MOV     ES,AX
        LEA     BP,TestChr
        MOV     AH,13H                  ;Function    = WRITE TEXT STRING
        MOV     AL,1                    ;Subfunction = update cursor
        MOV     BL,12H                  ;BL has attribute
        INT     10H                     ;Ask BIOS to display the string

        POP     BP
        POP     ES
        RET
_BIOS_Char_13   ENDP
