
;************************************************************************
; Using BIOS to determine display type, and save type in AX             *
; Exit: AX - Display type                                               *
;       0 => None                                                       *
;       3 => Enhanced Display (or Multi-scan)                           *
;       4 => Color Display                                              *
;       5 => Monochrome Display                                         *
;       7 => VGA Monochrome                                             *
;       8 => VGA Color (or Multi-scan)                                  *
;************************************************************************

        PUBLIC  _BIOS_Get_Display

_BIOS_Get_Display PROC    NEAR
        MOV     AX,1A00H                ;First look for VGA by trying fn=1A
        INT     10H
        CMP     AL,1AH                  ;There is no VGA if AL not 1A
        JNE     VGA_Not_In              ;...so go look for EGA
        MOV     AL,BL                   ;Return primary display info
        JMP     Type_Found

VGA_Not_In:
        MOV     AH,12H                  ;Select function 12hex
        MOV     BL,10H                  ;       subfunction 10hex
        INT     10H                     ;Call BIOS to get display type
        MOV     AL,5                    ;Assume that mono is attached
        OR      BH,BH                   ;Was display mono (BH = 1)?
        JNZ     Type_Found              ;...Yes, we are done
                                        ;...No, must look at switches
        MOV     AL,3                    ;Assume Enhanced display
        CMP     CL,9H                   ;Is switch 'off on on off'?
        JE      Type_Found              ;...Yes, we are done
        CMP     CL,3                    ;Is switch 'off off on on'?
        JE      Type_Found              ;...Yes, we are done
        MOV     AL,4                    ;...No, must be color display
Type_Found:
        XOR     AH,AH                   ;Clear AH
        RET
_BIOS_Get_Display ENDP
