
;************************************************************************
; Example of register read                                              *
; Read content of CRTC register 0E and 0F, the cursor address           *
; Exit: AX - Address of the cursor in display buffer                    *
;************************************************************************

        PUBLIC  _Get_Cursor_Address
_Get_Cursor_Address      PROC NEAR
        PUSH    ES
        XOR     AX,AX                   ;Set ES to point to BIOS data area
        MOV     ES,AX
        MOV     DX,ES:[BIOS_CRT_Addr]   ;Fetch CRTC address
        MOV     AL,0EH                  ;Fetch index
        OUT     DX,AL                   ;Select index
        INC     DX                      ;Increment register address
        IN      AL,DX                   ;Read the register value
        JMP     $+2
        MOV     BH,AL                   ;Save high half of the address
        DEC     DX                      ;Fetch CRTC address
        MOV     AL,0FH                  ;Fetch index
        OUT     DX,AL                   ;Select index
        INC     DX                      ;Increment register address
        IN      AL,DX                   ;Read the register value
        JMP     $+2
        MOV     AH,BH                   ;Copy high half of the address
        POP     ES
        RET                             ;Return address in AX
_Get_Cursor_Address     ENDP
