title mse_edt1.asm
comment+
	This combines the ``editor program'' pgm12_3.asm
	with our basic mouse functions mse-2.ams.

	The procedures in mse-2.ams are rewritten as procedures.
end comment+
.model small
.stack 100h
.data
; none here
IF1
	include mymacros.lib
ENDIF
EXTERN INIT:NEAR, CLEAR:NEAR
.code
main proc
; save video mode
        mov ah,0fh
        int 10h
        SAVE <ax,bx>    ; al=curr mode, ah=chars/line, bh=curr page
; set video mode
	mov ah,0
	mov al,3	; mode 3 (text mode, 80x25 size)
	int 10h
;move cursor
	mov ah,2
	xor dx,dx	; dh:dl=row:col, initialized to 0:0
	mov bh,0	; page number
	int 10h
; get keystroke
	mov ah,0	; output: ah=scan code, al=ascii code
	int 16h
while_: cmp al,1bh	; 1bh=ESC character
	je end_while
; if function key
	cmp al,0
	jne else_
;then
	call do_function
	jmp next_key
else_:	mov ah,2
	mov dl,al
	int 21h
next_key:	
	mov ah,0
	int 16h
	jmp while_
end_while:
; restore old mode
        RESTORE <bx,ax>
        mov ah,0        ; fcn=set mode (to old mode)
        int 10h
	DOS_RTN		; call macro
main endp

;  --------------------------------------------------------
;  DO_FUNCTION: moves the cursor according to function keys
;  --------------------------------------------------------
do_function proc
	push bx
	push cx
	push dx
	push ax
;
	mov ah,3
	mov bh,0
	int 10h
	pop ax	; retrieves scan code
;case of
	cmp ah,72	; uparrow?
	je cursor_up
	cmp ah,75	; left arrow?
	je cursor_left
	cmp ah,77	;right arrow?
	je cursor_right
	cmp ah,80	;down arrow?
	je cursor_down
	jmp exit
cursor_up:
	cmp dh,0	; row 0?
	je scroll_down
	dec dh		; no, row=row-1
	jmp execute
cursor_down:
	cmp dh,24	; last row?
	je scroll_up	
	inc dh		;no, row :=+1
	jmp execute
cursor_left:
	cmp dl,0		; col 0?
	jne go_left
	cmp dh,0	; row 0?
	je scroll_down
	dec dh		; row =- 1
	mov dl,79
	jmp execute
cursor_right:
	cmp dl,79	;last col?
	jne go_right
	cmp dh,24	;last row?
	je scroll_up
	inc dh		;row=+1
	mov dl,0
	jmp execute
go_left:
	dec dl
	jmp execute
go_right:
	inc dl
	jmp execute
scroll_down:
	mov al,1
	xor cx,cx
	mov dh,24
	mov dl,79
	mov bh,7
	mov ah,7
	int 10h
	jmp  exit
scroll_up:
	mov al,1
	xor cx,cx
	mov dx,184fh
	mov bh,7
	mov ah,6
	int 10h
	jmp exit
execute:	mov ah,2
	int 10h
exit:	pop dx
	pop cx
	pop bx
	ret
do_function endp

        end main
