; v22.0201.001, Fall 1996, Yap
	title mse_line.asm or mse3.asm
; solution to the mouse problem in final exam
; The following can be assembled and run directly 
; It is actually a cute problem to assign for homework!
	.model small
	.stack 100h
if1
	include ..\mac\basic.mac
endif
	.data
	curr_pos db 40
	.code
	main proc
	initdata	;macro
  ; get old video mode
	mov ah,0fh
	int 10h
	save <bx,ax>	;macro
  ; set new video mode
	xor ah,ah
	mov al,3	; mode 3
	int 10h
  ; mouse reset
	xor ax,ax
	int 33h
  ; init screen
	mov bl,44h	; red
	mov cx,40
  red:
	dec curr_pos	; initially curr_pos is 40
	call draw_col
	loop red
  ; next do blue half of screen
	mov bl,11h	; blue
	mov cx,39
	mov curr_pos,79
  blue:
	call draw_col
	dec curr_pos
	loop blue
  ; now curr_pos is at 40
	mov bl,77h
	call draw_col	; draw the white line
  mainloop:
	call update	; do the update step
	mov ax,3
	int 33h
	test bx,0111b	; is any mouse button pressed?
	jz mainloop
  ; clean up
	pop ax		; restore display mode
	mov ah,0
	int 10h
	pop bx		; restore active page
	mv al,bh
	mov ah,5
	int 10h
  ; dos return
	mov ah,4ch
	int 21h	
main	endp
; ****************************************
;input:  the column number in curr_pos
;         the color (attribute) in the bl register
draw_col proc 
	 save <as,bx,cx,dx>	;macro
 mov   dl, curr_pos
	 mov   dh, 0      ; start in row 0
	 mov   cx, 1      ; one char at a time
	 mov   al, ' '    ; write out spaces
  col_loop:
	; set cursor position
         mov   bh,0   
         mov   ah,2
         int   10h
	; paint one character
         mov   bh,0          ; write the characters
         mov   ah,9
         int   10h
	;
	 inc   dh         ; next row
	 cmp   dh, 24
	 jbe   col_loop   ; end of screen??
	restore <dx,cx,bx,ax>	;macro
	 ret
draw_col endp
; ****************************************
update proc
	save <ax,bx,cx>	;macro
	mov ax,3
	int 33h		; get mouse pos
	mov ax,cx	; cx is horizontal pixel pos
	mov cl,3
	shr ax,cl	; divide by 8 to get column no.
	mov cl,al	; now cl has column no.
	cmp cl,curr_pos
	je done		; if cl=curr_pos, done!
	jg right	; if cl>curr_pos, move column to the right
  ; so mouse is to the left of curr_pos
	cmp curr_pos, 1
	jle done	; do not move left of column 1, so done!
	mov bl,11h	; blue color for foreground and background
	call draw_col
	dec curr_pos
	jmp done
  right:
	cmp curr_pos,78
	jge done	; do not move right of col.78, so done!
	mov bl,44h	; red color
	call draw_col
	inc curr_pos
  done:
	mov bl,77h	; white color
	call draw_col	; draw the white central line
	restore <cx,bx,ax>
	ret
  update endp
; ****************************************
	end main
	
