TITLE Extra_Procedures

PUBLIC filesave
PUBLIC store_pos, restore_pos, cursor_status, move_ptr
PUBLIc append
INCLUDE mymacros.lib
extrn file_name
.MODEL small
.DATA
                              
  CR EQU 0DH
  LF EQU 0AH
  line db cr,lf
 
  cursorpos     dw      ?       ; stores cursor position on current page
  tempchar    db 20h            ;temporary storage for append proc
                                ; filesave variables
 
  handle        dw      ?       ; file handle
  buffer        db      2000 dup (20h)
;
.CODE
;==========================================================
filesave proc near
  save_regs <ax, bx, cx, dx, ds>

  mov ah, 3Ch                   ; create a new file
  lea dx, file_name
  xor cx, cx                    ; cl - attribute byte - 0 means normal
  int 21h
  mov handle, ax                ; save file handle
                                ;write screen to file
  call store_pos
 
  mov ah, 2                     ; move cursor function
  mov bh, 0                     ; page
  sub dx,dx                     ;top left corner
  int 10h


  mov cx,2000                   ;number of bytes to store in array
  sub si,si                     ;clear si
READ:

  mov ah, 8h                    ; read character at cursor
  int 10h
  mov buffer[si],al             ;stores in array

  call ADV_CURSOR
  inc si
loop READ

  mov cx,25                     ;number of lines to write  
  mov bx, handle
  lea dx, buffer                ; move char into DX

write: 
  push cx                       ;save cx
  mov cx,80                     ;number of bytes to write
  mov ah, 40h                   ;write line to file
  int 21h
  mov ah,40h
  mov cx,2                      ;writes CR and LF
  push dx
  lea dx,line 
  int 21h
  pop dx                        
  add dx,80                     ;sets pointer to next line of BUFFER
  pop cx
loop write 
  mov ah, 3Eh                   ; close a file
  int 21h
  call restore_pos              ;restore registers
  restore_regs <ds, dx, cx, bx, ax>
  ret
filesave endp
;==========================================================
store_pos proc near             ; store cursor position if F1 is hit
  save_regs <ax, bx, cx, dx>

  mov ah, 3                     ; get cursor position and size function
  xor bh, bh                    ; page 0
  int 10h                       ; destroys cx, so save

  mov cursorpos, dx             ; save cursor position into a variable

  restore_regs <dx, cx, bx, ax>
  ret
store_pos endp
;==========================================================
restore_pos proc near           ; restore cursor position if F2 is hit
  save_regs <ax, dx>

  mov dx, cursorpos             ; get save cursor position
  mov ah, 2                     ; move cursor
  mov bh, 0                     ; THIS WILL CHANGE, I HAVE TO SAVE PAGE
  int 10h

  restore_regs <dx, ax>
  ret
restore_pos endp
;==========================================================
cursor_status proc near
  save_regs <ax, es, di>
  xor ax, ax
  mov ah, 2                     ; get keyboard flags
  int 16h
                                ; AL has flags
  test al, 80h                  ; 10000000b  test bit 7 to see if insert is on
jne saad
  append_cursor
  jmp done

saad:
  insert_cursor
                                ; macro - append_cursor
done:
  restore_regs <di, es, ax>
  ret
cursor_status endp
;==========================================================

append proc near
  save_regs <ax, bx, cx, dx>    ; save registers

  mov ah, 3h                    ; get cursor position
  sub bh,bh                     ; at page 0
  int 10h
  push dx
  mov cx,1
  mov tempchar,20h
@tops:

  mov ah,8                      ;read char at cursor
  int 10h       
  xchg tempchar,al              ;al contains ascii code of replacement char,
                                ;low byte of di contains current char
  mov ah,0ah                    ;write replacement char    
  int 10h
  cmp dl,79                     ;end of row?
  je tests                      ;yes? need more tests on cursor position 
  inc dl                        ;move cursor 
  mov ah,2       
  int 10h
  jmp @tops
tests:
  cmp tempchar,20h              ;is char blank?
  je @done                      ;if so, jump to @done
  cmp dh,24                     ;is cursor at row 24?
  je @scroll_screen             ;if so, jump to @scrool_screen
  sub dl,dl                     ;set cursor column to 0
  inc dh                        ;increase cursor row
  mov ah,2
  int 10h                       ;move cursor
  jmp @tops
@scroll_screen:                 ;scrolls screen up
  mov ah,6
  mov al,1                      ;number of lines to scroll
  mov bh,7                      ;attribute for blank lines
  sub cx,cx                     ;set row and column of upper left corner of window
  mov dx,184fh                  ;set row and column of lower right corner of window 
  int 10h                       ;execute scroll window
  mov ah,2                      ;move cursor 
  mov dx,1800h
  sub bh,bh
  int 10h
  mov al,tempchar               ;move character back to al
  mov ah,0ah                    ;write character 
  mov cx,1                      ;write 1 byte
  int 10h
  pop dx
  dec dh                        ;sets cursor down one
  push dx
@done:
  pop dx
  mov ah,2                      ;move cursor
  int 10h  
  restore_regs <dx, cx, bx, ax>
  ret
append endp
;==========================================================
move_ptr proc
  save_regs <ax,cx,dx>
  mov ah,3h                    ;gets cursor position
  int 10h
  cmp dl,79                    ;is cursor at end of line?
  jne next                     ;if not, jump
  mov cx,10                    ;number of bytes to write
  mov ah,40h                   ;write CR,LF to file
  mov dx,0dh                   
  int 21h
  mov dx,0ah
  int 21h
  ;mov ah,42h                  ;if so, move write cursor to next line
  ;xor cx,cx
  ;xor dx,dx
  ;mov al,1
  ;int 21h
next:
  restore_regs <dx,cx,ax>
  ret
move_ptr endp
;===========================================================
ADV_CURSOR proc
  save_regs <ax,bx,cx,dx>
  mov ah,3                     ;get current cursor position
  
sub bh,bh
int 10h
  inc dl                       
  cmp dl,80                    ;is cursor at last column?
  jnz end_ad                   ;if not, end procedure
  inc dh                       ;otherwise, move cursor to next row
  sub dl,dl
end_ad:
  mov ah,2
  int 10h
  restore_regs <dx,cx,bx,ax>
  ret
ADV_CURSOR endp
;==========================================================
end

