; This is program pgm15_3.asm (p.325 of text)
;
title prm15_3
; tsr program to show current time, called via ctrl-rt shift key combination.
EXTRN	initialize:near, save_screen:near
EXTRN restore_screen:near, set_cursor:near
EXTRN get_time:near
PUBLIC main
PUBLIC new_vec, old_vec, ss_buf
;
if1
  include mac\mac.asm
endif
;
c_seg segment PUBLIC
	assume cs:c_seg, ds:c_seg, ss:c_seg
	org 100h
start:	jmp initialize
;
ss_buf		db 16 dup(?)	; screen buffer saved
time_buf	db '00:00:00$'	;
cursor_pos	dw ?
on_flag		db 0		; 1=interrupt procedure running
new_vec		dw ?,?
old_vec		dd ?
;
main proc
; interrupt procedure
	save_regs	<ds,es,ax,bx,cx,dx,si,di>
	mov ax,cs
	mov ds,ax
	mov es,ax	; set up ds and es
; call old keyboard interrupt routine
; not matched?
;        pushf
	call old_vec
; get keybd flags
	mov ax,cs	; reset ds
	mov ds,ax
	mov es,ax	;    and es
	mov ah,02	; function 2, keybd flags
	int 16h		; al has flag bits
	test al,1		; right shift?
	je i_done	; no, exit
	test al,100b	; control?
	je i_done	; no, exit
; yes, begin processing
	cmp on_flag,1
	je restore	; if procedure active, deactivate
        mov on_flag,1   ; else activate
; save cursor position and screen info
	mov ah,03	; get cur pos
	mov bh,0	; pg 0
	int 10h		; dh,dl=row,col
	mov cursor_pos,dx	; save it
	call save_screen	; save time display screen
; position cursor
	mov dl,72
	call set_cursor
	lea bx,time_buf
	call get_time	; get current time
; display time
	lea si,time_buf
	mov cx,8
	mov bh,0	; pg 0
m1:	mov ah,0eh	; write char
	lodsb		; char in al
	int 10h		; cursor is moved to next col
	loop m1
	jmp res_cursor
restore:	
; restore screen
	mov on_flag,0	; clear flag
	call restore_screen
; restore cur pos
res_cursor:
	mov ah,02
	mov bh,0
	mov dx,cursor_pos
	int 10h
;restore registers
i_done:
	restore_regs <di, si, dx, cx, bx, ax, es, ds>
	iret
main endp
;
c_seg ends
	end start	
