
;************************************************************************
; Determine if a second video adapter is present                        *
; and return result in AX                                               *
; Exixt:  AX = 0 if there is no second adapter                          *
;            = 1 if there is a second adapter                           *
;************************************************************************

        PUBLIC  _Get_Second_Adapter

_Get_Second_Adapter PROC NEAR
        PUSH    ES                      ;Preserve ES
        XOR     AX,AX                   ;Move segment zero into ES
        MOV     ES,AX
        MOV     DX,03D4H                ;Assume mono attached
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono attached?
        JNZ     Find_Second             ;...Yes, go look for CGA
        MOV     DX,03B4H                ;...No, look for MDA

Find_Second:
        MOV     AL,0FH                  ;Select cursor low
        OUT     DX,AL
        MOV     AL,55H                  ;Write first pattern
        INC     DX
        OUT     DX,AL
        IN      AL,DX                   ;Read pattern back
        JMP     $+2
        CMP     AL,55H                  ;Is pattern same?
        JNE     No_Second               ;...No, adapter not there

        MOV     AL,0AAH                 ;Write second pattern
        OUT     DX,AL
        IN      AL,DX                   ;Read pattern back
        JMP     $+2
        CMP     AL,0AAH                 ;Is pattern same?
        JNE     No_Second               ;...No, adapter not there

        MOV     AX,1                    ;...Yes, return count 1
        POP     ES                      ;Restore ES
        RET

No_Second:
        XOR     AX,AX                   ;Return count 0
        POP     ES
        RET
_Get_Second_Adapter ENDP
