
;************************************************************************
; Determine maximum number of scan lines using the display type         *
; from BIOS variables in segment zero                                   *
; Exit: AX - Maximum number of scanlines (200, 350, 480)                *
;************************************************************************

        PUBLIC  _Get_Scanlines

_Get_Scanlines  PROC NEAR
        PUSH    ES                      ;Preserve ES
        MOV     AX,1A00H                ;Look for VGA (using BIOS)
        INT     10H
        CMP     AL,1AH                  ;Is VGA there? (AL=1A)
        JNE     No_VGA                  ;...No, go check EGA
        MOV     AX,480                  ;...Yes, must be 480 lines
        JMP     Found_Lines
No_VGA:
        XOR     AX,AX                   ;Move segment zero into ES
        MOV     ES,AX
        MOV     AL,ES:[BIOS_Equipment]  ;Fetch mono/color bit
        AND     AL,2                    ;Isolate bit1 and move it
        SHR     AL,1                    ; into bit0
        CMP     AL,1                    ;Was display type 1 (mono)?
        MOV     AX,350                  ;...assume so
        JE      Found_Lines             ;...Yes, we are done
                                        ;...No, must look at switches
        MOV     CL,ES:[BIOS_Switch]     ;Fetch switch settings
        AND     CL,0FH                  ;Isolate config switches
        MOV     AX,350                  ;Assume Enhanced display
        CMP     CL,9H                   ;Is switch 'off on on off'?
        JE      Found_Lines             ;...Yes, we are done
        CMP     CL,3                    ;Is switch 'off off on on'?
        JE      Found_Type              ;...Yes, we are done
        MOV     AX,200                  ;...No, must be color display
Found_Lines:
        POP     ES                      ;Restore ES
        RET
_Get_Scanlines  ENDP
