;ChoongHong Oh

TITLE PGM2:KEYBOARD INTERRUPT
        EXTRN SCAN_CODE : BYTE, KEY_FLAG : BYTE
        PUBLIC KEYBOARD_INT
.MODEL SMALL

IF1
        INCLUDE macro.ASM
ENDIF

.CODE
KEYBOARD_INT PROC
;keyboard interrupt routine

        SAVE_REGS <DS, AX>
;set up DS
        MOV AX, SEG SCAN_CODE
        MOV DS, AX
;input scan code
        IN AL, 60h      ;read scan code
        PUSH AX         ;save it
        IN AL, 61h      ;control port value
        MOV AH, AL      ;save in AH
        OR AL, 80h      ;set bit for key board
        OUT 61h, AL     ;write back
        XCHG AH, AL     ;get back control value
        OUT 61h, AL     ;reset control port
        POP AX          ;recover scan code
        MOV AH, AL      ;save sacn code in AH
        TEST AL, 80h    ;test for break code
        JNE KEY_0       ;yes, clear flags, goto KEY_0
;make code
        MOV SCAN_CODE, AL ;save in variable
        MOV KEY_FLAG, 1   ;set key flag
KEY_0:
        MOV AL, 20h     ;reset interrupt
        OUT 20h, AL
;restore registers
        RESTORE_REGS <AX, DS>
        IRET
KEYBOARD_INT ENDP       ;end KEYBOARD routine
        END
