;ChoongHong Oh

TITLE PGM1 : SET INTERRUPT VECTOR
PUBLIC SETUP_INT
.MODEL SMALL

IF1
        INCLUDE macro.ASM
ENDIF

.CODE
SETUP_INT PROC
;saves old vector and sets up new vector
;input: AL = interrupt number
;       DI = address of buffer for old vector
;       SI = address of buffer containing new vector

        SAVE_REGS <AX, DX, DS, ES>
;save old interrupt vector
        MOV AH, 35h      ;function 35h, get vector
        INT 21h          ;ES:BX = vector
        MOV [DI], BX     ;save offset
        MOV [DI+2], ES   ;save segment
;set up new vector
        MOV DX, [SI]     ;DX has offset
        MOV DS, [SI+2]   ;DS has segment number
        MOV AH, 25h      ;function 25h, set vector
        INT 21h
        RESTORE_REGS <ES, DS, DX, AX>
        RET
SETUP_INT ENDP
        END
