title vgablt4.asm
; variant of vgablt3.asm, but where 2 pages are exercised
;	Also, procedure CHECKER is defined!
;	
; basically exercises _BitBlt procedure from prog087.asm
; but we include the file vgabox.asm for drawing boxes,
;	in order to first create an interesting pattern...
; But there is the problem of data moving over itself as shown in this
;	example -- need a wrapper function
.model small
.stack 1000h
if1
	include ..\..\mac\basic.mac
endif
.data
MODE equ 10h		; display mode
;**************** old data from vgabox.asm ***********************
xx0	dw 100		;(xx0,yy0)=top left corner of (first) box
yy0	dw 50
width_ equ 50		; dimensions of boxes
height equ 24
no_boxes equ 18		; number of boxes
ccolor dw 1			; color of first box
xoffset equ 25
yoffset equ 12
xx1 	dw ?			; (xx1,yy1)=bottom right corner of boxes
yy1	dw ?
;**************** new data for BitBlt ***********************
comment+
old_x dw 150
old_y dw 5			; (old_x,old_y) is the old NE corner
new_x dw 150
new_y dw 150		; (new_x,new_y) is new NE corner
end comment+
; very weird: in mode 10h, the source and destination for _BitBlt
;	is exchanged!!!
old_x dw 150
old_y dw 150			; (old_x,old_y) is the old NE corner
new_x dw 150
new_y dw 5		; (new_x,new_y) is new NE corner
;
blk_x dw 200
blk_y dw 200		; (blk_x,blk_y) are dimensions of move
fcn	dw 0			; logical function: 0=copy, 1=and, 2=or, 3=xor (?)
;**************** end data ***********************
.code
main proc
initdata		; macro
;
mov ah,0		; set screen mode
mov al,MODE      	; mode 10h
int 10h
;
; DEBUG: how much EGA memory do I have? 
	mov ah,12h
	mov bl,10h	; Indicate subfunction "return video config"
	int 10h
	display_it 'BL = '
	outhex bl	
	display_it 'h.  0/1/2/3 = 64k/128k/192k/256k EGA memory.  '
	newline
	display_it 'This demo requires at least 128k EGA memory.'
	newline
; end DEBUG
;
save <no_boxes,xx0,yy0,xoffset,yoffset,width_,height,ccolor>
call boxes
add sp,16 		; pop off args
;
display_it 'Mode '
outhex MODE
display_it 'h, display 18 boxes in 16 default colors'
newlines 10
pause 'continue?'
newline
;
save <fcn,blk_y,blk_x,old_y,old_x,new_y,new_x>
; save <fcn,blk_y,blk_x,new_y,new_x,old_y,old_x>

call _BitBlt
add sp,14		; pop arguments
;
pause 'bitblt...'
;
; comment+
mov ah,5		; fcn=select active page
mov al,1		; page 1 (alternate page in mode 10h)
int 10h
; end comment+
save <10,10,0,0,64,35,2>
call checker
add sp, 14		; pop arguments
;
; pause "terminate?"
delay 50000 5000
;
mov ah,5
mov al,0
int 10h
pause "back to page 0!"
; restore mode
	mov ah,0
	mov al,3
	int 10h
;
exitdos
main endp

;
;&&&&&&&&&&&&&&&&&&&&& prog085.asm below &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;	whose main routine is called _solid_box.
include prog085.asm

;&&&&&&&&&&&&&&&&&&&&& prog087.asm below &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;
;************************************************************************
; Transfer Bit Aligned Block of dimensions Width x Height, from         *
; source, with upper left corner at (X_Src,Y_Src), to destination with  *
; upper left corner at (X_Dst,Y_Dst), using function fn.                *
; Entry:        X_Srs, Y_Src  - Source upper left                       *
;               X_Dst, Y_Dst  - Destination upper left                  *
;               BWidth,BHeight- Dimensions of the block                 *
;               Fn            - Logical function (Copy, AND, OR, XOR)   *
;************************************************************************
comment-
;xxxx add later traversing x in reverse for overlapped src and dst

X_Src   EQU     [BP+4]                  ;Formal parameters on the stack
Y_Src   EQU     [BP+6]
X_Dst   EQU     [BP+8]
Y_Dst   EQU     [BP+10]
BWidth  EQU     [BP+12]
BHeight EQU     [BP+14]
Fn      EQU     [BP+16]

HBYTES  EQU     80                      ;Number of bytes per scanline
GRF_SEG EQU     0A000H                  ;Segment for display buffer
end comment-

include prog087.asm

;&&&&&&&&&&&&&&&&&&&&& BOXES PROCEDURE &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

boxes	proc
	__no_boxes	equ [bp+18]
	__xx0		equ word ptr [bp+16]
	__yy0		equ word ptr [bp+14]
	__offsetx	equ [bp+12]
	__offsety	equ [bp+10]
	__width	equ [bp+8]
	__height	equ [bp+6]
	__color	equ word ptr [bp+4]
	__xx1		equ word ptr [bp-2]
	__yy1		equ word ptr [bp-4]
	; ***************************************	
	push bp
	mov bp,sp
	sub sp,4
	save <ax,bx,cx,dx>
	;
	mov cx,__no_boxes
	repeat:
	push cx		; cx is messed up by someone, so must save it
	mov ax,__xx0		; begin update xx1
	add ax,__width
	mov __xx1,ax		; xx1 = xx0+width
	mov ax,__yy0		; begin update yy1
	add ax,__height
	mov __yy1,ax			; yy1 = yy0+width
	save <__color,__yy1,__xx1,__yy0,__xx0>	; setting up arguments 
	call _solid_box				;   before calling _solid_box
	add sp,10		; i.e., restore <ccolor, yy1, xx1, yy0, xx0>
	mov ax,__xx0
	add ax,__offsetx
	mov __xx0,ax
	mov ax,__yy0
	add ax,__offsety
	mov __yy0,ax
	add __color, 1
	pop cx
	loop repeat
  ; restore registers
	restore <dx,cx,bx,ax>
	mov sp,bp
	pop bp
	ret
boxes	endp

;&&&&&&&&&&&&&&&&&&&&& CHECKER PROCEDURE &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

checker	proc
	__no_boxes_x	equ word ptr [bp+16]
	__no_boxes_y	equ word ptr [bp+14]
	__xx0		equ word ptr [bp+12]
	__yy0		equ word ptr [bp+10]
	__width	equ [bp+8]
	__height	equ [bp+6]
	__color	equ word ptr [bp+4]
	__xx1		equ word ptr [bp-2]
	__yy1		equ word ptr [bp-4]
	; ***************************************	
	push bp
	mov bp,sp
	sub sp,4
	save <ax,bx,cx,dx>
	;
	mov cx,__no_boxes_y
	repeat_col:
	push cx			; cx is messed up by someone, so must save it
	mov ax,__yy0	 	; begin update yy1
	add ax,__height
	mov __yy1,ax		; yy1 = yy0+width
	mov cx,__no_boxes_x
	repeat_row:
	push cx
	mov ax,__xx0		; begin update xx1
	add ax,__width
	mov __xx1,ax		; xx1 = xx0+width
	save <__color,__yy1,__xx1,__yy0,__xx0>	; setting up arguments 
	call _solid_box				;   before calling _solid_box
	add sp,10		; i.e., restore <ccolor, yy1, xx1, yy0, xx0>
	mov ax,__xx0
	add ax,__width
	mov __xx0,ax
	add __color,1
	pop cx
	loop repeat_row
	mov ax,__yy0
	add ax,__height
	mov __yy0,ax
	pop cx
	loop repeat_col
  ; restore registers
	restore <dx,cx,bx,ax>
	mov sp,bp
	pop bp
	ret
checker endp



	end main
