title clear.asm
.model small
; This program clears the screen.
; It basically calls _BIOS_Clear (from prog016.asm)
;
if1
	include ..\..\mac\basic.mac
endif
BIOS_Rows       EQU     484H            ;Number of text rows
BIOS_Columns    EQU     44AH            ;Number of text columns
.code
main proc
call _BIOS_Clear
exitdos
main endp

;************************************************************************
; Use BIOS call to clear memory                                         *
;************************************************************************

        PUBLIC  _BIOS_Clear

_BIOS_Clear     PROC NEAR
        PUSH    ES                      ;Save ES
        XOR     AX,AX                   ;Load 0 into ES
        MOV     ES,AX
        MOV     CX,0                    ;Set upper left to 0,0
        MOV     DH,ES:[BIOS_Rows]       ;Get lower right corner
        MOV     DL,ES:[BIOS_Columns]
; debugging: what is in DH, DL?
;	ANS: (18h,50h)=(24,80)!!
display_it 'dh=BIOS_ROWS= '
outhex dh
display_it '  dl=BIOS_COLS= '
outhex dl
        DEC     DH
        DEC     DL
        MOV     BH,7                    ;Normal attribute
        MOV     AH,6                    ;Function = SCROLL UP
        MOV     AL,0                    ;Subfunction = whole screen
        INT     10H                     ;Ask BIOS to scroll screen
        POP     ES                      ;Restore ES
        RET
_BIOS_Clear     ENDP

end main